/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: attrs.c,v 1.6 2003/04/11 17:47:16 jsquyres Exp $
 *
 * Test whether several MPI attributes are set correctly on
 * MPI_COMM_WORLD.
 *
 */

#include <stdio.h>
#include <mpi.h>

#include "lamtest_error.h"


int
get_attr(char* str, int key)
{
  void **attrp;
  int flag = 0;

  MPI_Comm_get_attr(MPI_COMM_WORLD, key, &attrp, &flag);
  if (flag != 1) {
    lamtest_error(__FILE__, __LINE__, "ERROR: Didn't get attribute %s\n", str);
    return 1;
  }

  return 0;
}


int
main(int argc, char* argv[])
{
  int ret = 0;

  MPI_Init(&argc, &argv);
  ret += get_attr("MPI_UNIVERSE_SIZE", MPI_UNIVERSE_SIZE);
  ret += get_attr("IMPI_CLIENT_SIZE", IMPI_CLIENT_SIZE);
  ret += get_attr("IMPI_CLIENT_COLOR", IMPI_CLIENT_COLOR);
  ret += get_attr("IMPI_HOST_SIZE", IMPI_HOST_SIZE);
  ret += get_attr("IMPI_HOST_COLOR", IMPI_HOST_COLOR);
  MPI_Finalize();

  return ret;
}
