/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: client_server.c,v 1.6 2003/06/03 03:34:04 jsquyres Exp $
 *
 * Program to test MPI_Comm_accept, MPI_Comm_connect, MPI_Conn_disconnect
 * using simple arguments.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <mpi.h> 
#include <lamtest_error.h>

int main(int argc, char **argv ) 
{ 
  int size, rank, port_length;
  MPI_Comm server, client;
  char *port_name;
  int buf = 1;

  MPI_Init(&argc, &argv);

  lamtest_check_size(__FILE__, __LINE__, 2, 1);

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) {
    /* Server code */
    port_name = malloc(MPI_MAX_PORT_NAME * sizeof(char));
    MPI_Open_port(MPI_INFO_NULL, port_name);
    port_length = strlen(port_name) + 1;

    /* send port length and port name to client (rank 1) */
    MPI_Send(&port_length, 1, MPI_INT, 1, 1, MPI_COMM_WORLD);
    MPI_Send(port_name, port_length, MPI_CHAR, 1, 1, MPI_COMM_WORLD);

    MPI_Comm_accept(port_name, MPI_INFO_NULL, 0, MPI_COMM_SELF, &client);
    MPI_Recv(&buf, 1, MPI_INT, 0, 1, client, MPI_STATUS_IGNORE);
    MPI_Comm_disconnect(&client);
    MPI_Close_port(port_name);
    free(port_name);

  } else if (rank == 1) {
    /* Client code */

    MPI_Recv(&port_length, 1, MPI_INT, 0, 1, MPI_COMM_WORLD, 
	     MPI_STATUS_IGNORE);

    /* allocate memory for the the port name */
    port_name = malloc(port_length * sizeof(char));
    MPI_Recv(port_name, port_length, MPI_CHAR, 0, 1, MPI_COMM_WORLD, 
	     MPI_STATUS_IGNORE);

    /* connect to the server */
    MPI_Comm_connect(port_name, MPI_INFO_NULL, 0, MPI_COMM_SELF, &server);
    MPI_Send(&buf, 1, MPI_INT, 0, 1, server);
    MPI_Comm_disconnect(&server);
    free(port_name);
  }

  MPI_Finalize();
  return 0;
} 
