/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame.
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.
 *                         All rights reserved.
 *
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: datatype_cxx.cc,v 1.6 2003/06/27 03:24:14 jsquyres Exp $
 *
 * tests MPI::Datatype::Get_extent, MPI::Datatype::Create_vector,
 * MPI::Datatype::Create_hvector, MPI::Datatype::Set_name,
 * MPI::Datatype::Get_name, MPI::Datatype::Get_envelope, MPI::Datatype::Commit
 */

#include <string.h>
#include <stdlib.h>
#include <mpi.h>

#include <lamtest_error.h>


int 
main(int argc, char **argv)
{
  int i1, i2, i3, i4; 
  int length;
  char name[MPI_MAX_OBJECT_NAME];
  MPI::Intracomm intracomm;
  MPI::Datatype subrow, submatrix;
  MPI::Datatype integer;
  MPI::Aint lb;
  MPI::Aint extent;
  
  MPI::Init(argc, argv);
  intracomm = MPI::COMM_WORLD;
  integer = MPI::INT;

  /* Create a submatrix datatype */
  integer.Get_extent(lb, extent);
  
  /* Create datatype for the sub-row */
  subrow = integer.Create_vector(5, 1, 2);

  /* Commit the datatype created */
  subrow.Commit();
  
  /* Create datatype for the sub-matrix */
  submatrix = subrow.Create_hvector(5, 1, 20*extent);
  
  /* Commit the datatype created */
  submatrix.Commit();
  
  /* give name to submatrix */
  submatrix.Set_name("SUBMATRIX");
  
  /* get the name and check */

  submatrix.Get_name(name, length);
  if (strcmp(name, "SUBMATRIX")) {
    lamtest_error(__FILE__, __LINE__,
		  "Expecting SUBMATRIX got %s", name);
  }

  /* get envelope and contents */
  submatrix.Get_envelope(i1, i2, i3, i4);
  
  if (i1 != 2) {
    lamtest_error(__FILE__, __LINE__,
                  "Expecting 2 got %d", i1);
  }
  if (i2 != 1) {
    lamtest_error(__FILE__, __LINE__,
                  "Expecting 1 got %d", i2);
  }
  if (i3 != 1) {
    lamtest_error(__FILE__, __LINE__,
                  "Expecting 1 got %d", i3);
  } 
  if (i4 != 5) {
    lamtest_error(__FILE__, __LINE__,
                  "Expecting 5 got %d", i4);
  }

  submatrix.Free();
  subrow.Free();
  MPI::Finalize();
  return 0;
}
