dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: mpi_check_link.m4,v 1.2 2002/10/09 20:55:41 brbarret Exp $
dnl

define([LSC_MPI_CHECK_LINK],[
#
# Arguments: None
#
# Dependencies: None
# 
# Try to link a simple program, see if we can find the symbol
# MPI_Initialized.
# Aborts if we cannot.
#

AC_MSG_CHECKING([for MPI_Initialized in -lmpi])
# See if we can -lmpi (or whatever)
AC_TRY_LINK(#include <mpi.h>
, int i; MPI_Initialized(&i);, lsc_libmpi_found=yes, lsc_libmpi_found=no)
if test "$lsc_libmpi_found" = "yes"; then
    AC_MSG_RESULT([yes])
else
    lsc_save_LIBS="$LIBS"
    LIBS="$LIBS -lmpi"
    AC_TRY_LINK(#include <mpi.h>
, int i; MPI_Initialized(&i);, lsc_libmpi_found=yes, lsc_libmpi_found=no)
    if test "$lsc_libmpi_found" = "yes"; then
	AC_MSG_RESULT([yes])
    else
	AC_MSG_RESULT([no])
	AC_MSG_ERROR([cannot continue -- cannot find MPI_Initialized])
    fi
    LIBS="$lsc_save_LIBS"
fi
unset lsc_libmpi_found])dnl
