dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2003 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lamtest_check_supposed_f77.m4,v 1.1 2003/03/28 14:40:01 jsquyres Exp $
dnl

define(LAMTEST_CHECK_SUPPOSED_TO_HAVE_F77,[
#
# Are we *supposed* to have fortran support?
# Will only work for LAM/MPI
#
AC_MSG_CHECKING([if supposed to have Fortran MPI bindings])
AC_TRY_RUN([
#include <mpi.h>

int
main(int argc, char* argv[])
{
#if LAM_WANT_FORTRAN
  return 0;
#else
  return 1;
#endif
}], SUPPOSED_TO_HAVE=yes, SUPPOSED_TO_HAVE=no, SUPPOSED_TO_HAVE=no)
AC_MSG_RESULT([$SUPPOSED_TO_HAVE])

if test "$HAVE_MPI_F77" = "no" -a "$SUPPOSED_TO_HAVE" = "yes"; then
    AC_MSG_ERROR([Cannot continue])
fi])dnl
