/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: self_atexit.c,v 1.3 2003/06/02 02:25:34 jsquyres Exp $
 */

#include <stdio.h>

#include <mpi.h>

#include "lamtest_error.h"


/*
 * Global variable
 */
int ret = 1;


int
delete_function(MPI_Comm comm, int keyval, void *attribute_val, 
		void *extra_state)
{
  ret = 0;
  return 0;
}


int
main(int argc, char *argv[])
{
  int me, tasks;
  int key, intval;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &me);
  MPI_Comm_size(MPI_COMM_WORLD, &tasks);

  /* Create a keyval with an associated delete function */

  MPI_Keyval_create(MPI_NULL_COPY_FN, delete_function, &key, 0);

  /* Now attach an arbitrary attribute on that keyval on
     MPI_COMM_SELF */

  intval = 17;
  MPI_Comm_set_attr(MPI_COMM_SELF, key, &intval);

  /* The keyval delete function should be triggered during
     MPI_Finalize() */

  MPI_Finalize();
  return ret;
}
