/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame.
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.
 *                         All rights reserved.
 *
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: comm_get_name_cxx.cc,v 1.2 2003/06/27 12:56:29 jsquyres Exp $
 *
 * tests MPI::Init MPI::Intracomm::Set_name, MPI::Intracomm::Get_name
 */

#include <string.h>
#include <mpi.h>

#include <lamtest_error.h>


int 
main(int argc, char**argv)
{
  int length;
  char name[MPI_MAX_OBJECT_NAME];

  MPI::Intracomm intracomm;
  MPI::Init();
  intracomm = MPI::COMM_WORLD;
  intracomm.Set_name("WORLD");
  intracomm.Get_name(name, length);
  if (strcmp(name,"WORLD")) {
    lamtest_error(__FILE__, __LINE__,
		  "Expecting WORLD got %s", name);
  }

  MPI::Finalize();
  return 0;
}
