/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	$Id: tfseek.c,v 6.3 1999/05/27 20:07:07 kmeyer1 Exp $
 *
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <errno.h>

#include <laminternal.h>
#include <tstdio.h>


long
tftell(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_CUR);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : rv);
}

int
tfseek(fp, offset, origin)
	TFILE *fp;
	long offset;
	int origin;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, offset, origin);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : 0);
}

void
trewind(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_SET);
	if(rv < 0)
		errno = ((int) rv);
	fp->_flag &= ~(_TIOEOF|_TIOERR);
}
