/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	$Log: tfdopen.c,v $
 *	Revision 6.2  1999/05/27 20:07:05  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:35:53  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:06:27  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:31  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:45  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:52  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/02/16  14:34:28  raja
 * Use the CONST macro.
 * 
 * Revision 2.2  93/05/10  16:36:51  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <fcntl.h>

#include <portable.h>
#include <tstdio.h>

#define isiodev(d) ((d)<3)	/* instead of isatty(d) */
#define isstdout(d) ((d)==1)
#define isstderr(d) ((d)==2)

TFILE *
tfdopen(h, mode)
	int h;
	CONST char *mode;
{
	int i, f = 0;
	TFILE *fp = NULL;

	for(i=0; (!fp && (i < _TNFILE)); ++i)
		if(!(_tiob[i]._flag & (_TIOREAD | _TIOWRT))) /* empty slot? */
			fp = &_tiob[i];
	if(!fp)
		return(NULL);

	/*
	 * The CRLF --> \n translation left in fgetc/fputc in case we ever go
	 * back to MS-DOS.  To compensate we default to binary mode here.
	 */
	f |= _TIOBIN;

	while(*mode)
	{
		switch(*mode++)
		{
		case 'r':
			f |= _TIOREAD;
			break;
		case 'w':
			f |= _TIOWRT;
			break;
		case 'a':
			f |= _TIOWRT;
			break;
		case '+':
			f |= (_TIOREAD | _TIOWRT);
			break;
		case 'b':
			f |= _TIOBIN;
			break;
		case 't':
			f &= ~_TIOBIN;
			break;
		case 'T':
			f |= _TIOREMOTE;
			break;
		default:
			return(NULL);
		}
	}
	if((f & (_TIOREAD | _TIOWRT)) == 0)
		return(NULL);
	if(isiodev(h)) {
		f |= _TIODEV;
		if (isstderr(h))
			f |= _TIONBF;
		else if (isstdout(h))
			f |= _TIOLBF;
		else
			f |= _TIOFBF;
	} else
		f |= _TIOFBF;
	fp->_file = h;			/* file handle */
	fp->_flag = f;			/* file status flags */
	fp->_base = NULL;		/* base of file buffer */
	fp->_ptr = NULL;		/* current buffer pointer */
	fp->_bsiz = 0;			/* buffer size */
	fp->_cnt = 0;			/* # of bytes in buffer */
	return(fp);
}
