/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lamfault.c,v 1.1 2000/05/06 17:34:52 jsquyres Exp $
 *
 *	Function:	- LAM-MPI fault tolerance
 */

#include <all_list.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 *	lam_commfault
 *
 *	Function:	- invalidate communicators involving a dead node
 *	Accepts:	- dead node's id
 */
void
lam_commfault(node)

int			node;

{
	MPI_Comm	*comm;			/* communicator */
	struct _proc	**p;
	int		i;
	
	comm = al_top(lam_comms);

	for ( ; comm; comm = al_next(lam_comms, comm)) {
/*
 * There is nothing to do if the local group is already dead.
 */
		if ((*comm)->c_flags & LAM_CLDEAD) continue;
/*
 * Check the local group.
 */
		p = (*comm)->c_group->g_procs;
		
		for (i = (*comm)->c_group->g_nprocs; i > 0 ; i--, p++) {

			if ((*p)->p_gps.gps_node == node) {
				(*comm)->c_flags |= LAM_CLDEAD;
				break;
			}
		}
/*
 * If it's an intercommunicator and the remote group is not dead, then
 * check the remote group.
 */
		if (LAM_IS_INTER(*comm) && ! ((*comm)->c_flags & LAM_CRDEAD)) {
			
			p = (*comm)->c_rgroup->g_procs;

			for (i = (*comm)->c_rgroup->g_nprocs; i > 0 ;
					i--, p++) {

				if ((*p)->p_gps.gps_node == node) {
					(*comm)->c_flags |= LAM_CRDEAD;
					break;
				}
			}
		}
	}
}
