/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wgetname.c,v 1.4 2001/02/03 20:51:49 arodrig6 Exp $
 *
 *	Function:	- get window name
 *	Accepts:	- window
 *			- window name (out)
 *			- window name length (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
   MPI_Win_get_name - Get the name associated with a window

Input Parameters:
. type - MPI window

Output Parameters:
+ name - Name of the window
- length - Integer length of the resulting name

Notes:

This function returns the name of a window that was previously set
with 'MPI_Win_set_name'.  If a name was not previously associated
with a window, the returned string will be empty and 'length' will
be 0.  The retuned name will be a maximum of 'MPI_MAX_OBJECT_NAME'
characters long.

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_COMM
.N MPI_ERR_ARG

.seealso MPI_Comm_get_name(3), MPI_Comm_set_name(3), MPI_Type_get_name(3), MPI_Type_set_name(3), MPI_Win_set_name(3)

.N WEB
@*/
int
MPI_Win_get_name(MPI_Win win, char *name, int *length)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINGETNAME);
/*
 * Check the arguments.
 */
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINGETNAME, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	err = MPI_Comm_get_name(win->w_comm, name, length);

	lam_resetfunc_m(BLKMPIWINGETNAME);
	return(err);
}
