/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: querythr.c,v 6.3 2001/01/26 17:04:19 jsquyres Exp $
 *
 *	Function:	- query level of thread support in MPI
 *	Accepts:	- ptr to provided level
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdio.h>

#include <mpi.h>
#include <mpisys.h>
#include <lamthreads.h>
#include <blktype.h>


/*@
   MPI_Query_thread - Check level of thread support in MPI

Output Parameter:
. pprovided - provided level of thread support

Description:

This function is mainly here for link-compatability.  It will
[currently] only ever return 'MPI_THREAD_SINGLE' in 'pprovided'.
Future versions of LAM/MPI will support multi-threaded user programs,
in which case 'MPI_Init_thread' must be used to initialize MPI.  Hence,
programmers can use this function now in order to program for future
flexibility.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.seealso MPI_Init_thread(3), MPI_Is_thread_main(3)

.N WEB
@*/
int
MPI_Query_thread(int *pprovided)
{
  lam_setfunc(BLKMPIQUERYTHREAD);

  if (pprovided == NULL) {
    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIQUERYTHREAD,
		       lam_mkerr(MPI_ERR_ARG, EMPIINIT)));
  }
  
  *pprovided = lam_thread_level;
  
  lam_resetfunc(BLKMPIQUERYTHREAD);
  return(MPI_SUCCESS);
}

