/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infocreate.c,v 6.5 2001/02/03 20:24:57 jsquyres Exp $
 *
 *	Function:	- info object constructor
 *	Accepts:	- info (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * private functions
 */
static int		info_key_cmp();


/*@
  MPI_Info_create - Create and initialize an empty MPI_Info object

Output Parameter:
. info - info object (handle)

Notes:

Upon successful return, the created 'MPI_Info' object will contain no
(key, value) pairs.

When an info object is no longer being used, it should be freed with
'MPI_Info_free'.

.N fortran

.N Errors
.N MPI_ERR_ARG
.N MPI_ERR_EXHAUSTED

.seealso: MPI_Info_free

.N WEB
@*/
int MPI_Info_create(MPI_Info *info)
{
        lam_initerr_m();
	lam_setfunc_m(BLKMPIINFOCREATE);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((*info = (MPI_Info) malloc(sizeof(struct _info))) == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*info)->info_list = al_init(sizeof(struct _infoent), info_key_cmp);
	if ((*info)->info_list == 0) {
		free((char *) *info);
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*info)->info_f77handle = -1;

        lam_resetfunc_m(BLKMPIINFOCREATE);
	return(MPI_SUCCESS);
}

/*
 *	info_key_cmp
 *
 *	Function:	- compare two info pairs by key
 *	Accepts:	- ptr to two pairs
 *	Returns:	- string comparison of keys
 */
static int
info_key_cmp(a, b)

struct _infoent	*a;
struct _infoent	*b;

{
	return(strcmp(a->ie_key, b->ie_key));
}
