/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: keycreate_f.c,v 6.7 2000/04/06 21:42:12 jsquyres Exp $
 *
 *	Function:	- MPI_Keyval_create F77	wrapper
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void 
mpi_keyval_create_(cf, df, k, es, ierr)

void	(*cf) ();
void	(*df) ();
int	*k, *es, *ierr;

{
	MPI_Copy_function 	*cf_C;
	MPI_Delete_function 	*df_C;
	struct _attrkey 	*pk;

	if ((cf == mpi_null_copy_fn_ || cf == mpi_comm_null_copy_fn_)) {
	    cf_C = 0;
	}
#if LAM_FORTRANCAPS
/*
 * In this case the C and Fortran are the same. Check against the C function
 * and replace it with a Fortran version if there is a match.
 */
	else if ((void *) cf == (void *) MPI_DUP_FN) {
	    cf_C = (MPI_Copy_function *) MPI_F_DUP_FN;
	}
	else if (cf == (void *) MPI_COMM_DUP_FN) {
	    cf_C = (MPI_Copy_function *) MPI_F_COMM_DUP_FN;
	}
#endif
	else {
	    cf_C =  (MPI_Copy_function *) cf;
	}

	df_C = (df == mpi_null_delete_fn_ || df == mpi_comm_null_delete_fn_)
	    		? 0 : (MPI_Delete_function *) df;

	*ierr =	MPI_Keyval_create(cf_C, df_C, k, 
				  (void *) LAM_INT_TO_VOID_P *es);

	if (*ierr == MPI_SUCCESS) {
		pk = lam_getattr(*k);
		pk->ak_flags |= LAM_LANGF77;
	}
}
