/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: lamnet.h,v 6.6 2000/07/14 23:29:27 jsquyres Exp $
 * 
 *	Function:	- LAM network description
 */

#ifndef _LAMNET
#define _LAMNET

#include <lam_config.h>
#include <sys/types.h>
#include <netinet/in.h>

#include <portable.h>

/*
 * default filenames
 */
#define DEFFBHOST	"lam-bhost.def"	/* default host file */

/*
 * default search paths
 */
#ifndef DEFPBHOST
#define DEFPBHOST	"/tmp/lam/boot"	/* default boot directory */
#endif

/*
 * default tools
 */
#define DEFTHBOOT	"hboot"
#define DEFTTKILL	"tkill"
#define DEFTWIPE	"wipe"

/*
 * node description
 */
struct lamnode {			/* node information */
	int4		lnd_nodeid;	/* node identifier */
	int4		lnd_type;	/* node type */
	int4		lnd_ncpus;	/* number of CPUs on node */
	int		lnd_bootport;	/* booting port # */
	char		*lnd_hname;	/* host name */
	char		*lnd_uname;	/* user name */
	struct sockaddr_in
			lnd_addr;	/* internet address */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		lamnet_dups __ARGS((struct lamnode *lamnet,
					int nlamnet, int *pdup));
extern int		lamnet_findhosts __ARGS((struct lamnode *lamnet,
					int nlamnet, int *badhost));
extern int		lamnet_findorig __ARGS((struct lamnode *lamnet,
					int nlamnet));

#ifdef __cplusplus
}
#endif

#endif	/* _LAMNET */
