/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: laminternal.h,v 1.5 2000/10/15 16:59:05 jsquyres Exp $
 *
 *	Function:	- prototypes for internally used LAM functions
 */

#ifndef _LAM_INTERNAL_H
#define _LAM_INTERNAL_H

#include <sys/types.h>
#include <sys/uio.h>

#include <lam_config.h>
#include <kreq.h>
#include <portable.h>
#include <tstdio.h>
#include <typical.h>

#ifdef __cplusplus
extern "C" {
#endif

extern char	*getworkdir __ARGS((void));
extern int	getinetaddr __ARGS((char *, unsigned char *));

extern char	*get_batchid __ARGS((void));
extern void	set_killname __ARGS((char *));
extern char	*killname __ARGS((void));
extern char 	*sockname __ARGS((void));
extern char 	*iosockname __ARGS((void));

extern int	lam_mktmpid __ARGS((int, char *, unint));

extern int      microsleep __ARGS((unsigned int	usec));

extern void	lam_cleanup_objects __ARGS((void));

extern void	(*(_lam_signal())) __ARGS((int, void (*) ()));

extern int4	stoi __ARGS((unsigned char *));

extern void	nodespin_init __ARGS((char *));
extern void	nodespin_next __ARGS((int4));
extern void	nodespin_end __ARGS((void));

extern void	_cio_cleanup __ARGS((void));
extern void	_cio_bail __ARGS((int));
extern int	_cipc_ksrfront __ARGS((struct kreq *, struct kreply *));
extern int	_cipc_ksrback __ARGS((struct kreq *, struct kreply *));

extern off_t 	lam_iomap_lseek __ARGS((unsigned int, int, off_t, int));
extern int 	lam_iomap_open __ARGS((unsigned int, char *, int, int));
extern int	lam_iomap_close __ARGS((unsigned int, int));
extern int 	lam_iomap_read __ARGS((unsigned int, int, char *, int));
extern int 	lam_iomap_write __ARGS((unsigned int, int, const char *, int));

extern void 	_getbuf __ARGS((register TFILE *));
extern int	_fmt __ARGS((TFILE *, char *, const char *, ...));

extern int	 mread __ARGS((int, char *, int4));
extern int	 mreadv __ARGS((int, struct iovec *, int));
extern int	 mwrite __ARGS((int, const char *, int));
extern int	 mwritev __ARGS((int, struct iovec *, int));

#ifdef __cplusplus
}
#endif

#endif	/* _LAM_INTERNAL_H */
