/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: app_schema.h,v 6.8 2000/01/31 19:37:06 jsquyres Exp $
 * 
 *	Function:	- application schema templates and constants
 */

#ifndef _APP_SCHEMA_H
#define _APP_SCHEMA_H

#include "all_list.h"
#include "app_mgmt.h"
#include "lam.h"

/*
 * GER (Guaranteed Envelope Resources)
 */
#ifndef MPI_GER
#define MPI_GER			8
#endif

/*
 * structures 
 */
struct apparg {
	int4		apa_refcount;		/* reference count */
	int4		apa_argc;		/* # cmd line args */
	char		**apa_argv;		/* cmd line args */
};

struct appenv {
	int4		ape_refcount;		/* reference count */
	char		**ape_envv;		/* cmd line args */
	char		*ape_wrkdir;		/* working dir */
};

struct aschema {
	int4		asc_srcnode;		/* binary source node */
	int4		asc_node;		/* single target node */
	int4		asc_proc_cnt;		/* # processes this entry */
	int4		asc_errno;		/* error code */
	LIST *		asc_nodelist;		/* nodes this entry */
	struct apparg *	asc_args;		/* cmd line args */
	struct appenv *	asc_env;		/* environment */
};

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	asc_bufparse(char *buf, int size, int *pl, char **env);
extern LIST *	asc_parse(const char *file, int *pl, char **env);
extern LIST *	asc_schedule(LIST *ap);
extern void	asc_free(LIST *ap);
extern int	asc_compat(int *argc, char ***argv);
extern int	asc_run(LIST *ap, int np, int4 rtf, int v,
			int e, struct _gps *p);
extern int	asc_ger(LIST *ap, int e);
extern int	asc_environment(int exportme, char *v, char ***env);
extern int	asc_workdir(LIST *ap, char *wrkdir);

#ifdef __cplusplus
}
#endif

#endif	/* _APP_SCHEMA_H */
