/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: regsyncackinit.c,v 1.1 2000/10/25 23:39:57 jsquyres Exp $
 *
 *	Function:	- post a receive for a ping from the impid
 */

#include <lam_config.h>
#if LAM_WANT_IMPI

#include <impi-defs.h> 
#include <impi.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>


/*
 *	IMPI_Register_syncack_init
 *
 *	Function:	- register to receive a syncack ping from the impid
 *                      - impid will send a ping to ack the receipt of
 *                        a DATASYNC on the remote site
 *                      - hence, this function is only invoked for sends
 *      Accepts:        - rank in comm where the real message is from
 *                      - tag of real message
 *                      - comm of real message
 */
int
IMPI_Register_syncack_init(int rank, int tag, MPI_Comm comm, MPI_Request *req)
{
  IMPI_Uint8 *drqid;

  *req = MPI_REQUEST_NULL;

  if (LAM_IS_IMPI(comm) &&
      lam_impid_proc != 0 &&
      (LAM_GPSCMP(&(comm->c_group->g_procs[rank]->p_gps),
		  &(lam_impid_proc->p_gps)) == 0 ||
       rank == MPI_ANY_SOURCE)) {
    int cid;
    int err;

    /* Change the CID of the request so that we won't interfere with
       the user's real message */

    cid = comm->c_contextid;
    comm->c_contextid = lam_pt2impisyncack(cid);

    drqid = (IMPI_Uint8 *) malloc(sizeof(IMPI_Uint8));
    err = _mpi_req_build(drqid, 1, IMPI_TYPE_UINT8, rank, tag, comm,
			 LAM_RQIRECV, req);
    if (err != MPI_SUCCESS) {
      *req = MPI_REQUEST_NULL;
      return(LAMERROR);
    }

    (*req)->rq_marks |= (LAM_RQFPERSIST | LAM_RQFDYNBUF | LAM_RQFMAND);
    (*req)->rq_hdlr = 0;
    comm->c_contextid = cid;
  }

  return MPI_SUCCESS;
}

#endif /* LAM_WANT_IMPI */
