/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	Copyright 1995 The Ohio State University
 *	$Id: nodespin.c,v 6.4 2000/11/02 07:21:27 jsquyres Exp $
 *
 *	Function:	- pretty prints successive node ID messages
 */

#include <stdio.h>

#include <args.h>
#include <portable.h>

/*
 *	nodespin_init
 *
 *	Function:	- prints initial message
 *	Accepts:	- message
 */
void
nodespin_init(char *msg)
{
  printf("%s           ", msg);
}

/*
 *	nodespin_next
 *
 *	Function:	- prints next node ID
 *	Accepts:	- node ID
 */
void
nodespin_next(int4 node)
{
  char buf[16];

  sprintf(buf, "%s...", nid_fmt(node));
  printf("%-10.10s", buf);
  fflush(stdout);
}

/*
 *	nodespin_end
 *
 *	Function:	- completes node message
 */
void
nodespin_end(void)
{
  printf("%-10.10s\n", "done");
}
