/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: app_mgmt.c,v 6.6 1999/09/12 05:06:22 jsquyres Exp $
 *
 *	Function:	- application execution and management
 */

#include <app_mgmt.h>
#include <lam_ksignal.h>
#include <net.h>
#include <preq.h>
#include <typical.h>

/*
 * public functions
 */
int			app_doom();
int			app_sendprocs();

/*
 *	app_sendprocs
 *
 *	Function:	- send GPS array to all processes in the array
 *	Accepts:	- number of processes in GPS array
 *			- GPS array
 *	Returns:	- 0 or LAMERROR
 */
int
app_sendprocs(nprocs, pgps)

int			nprocs;
struct _gps		*pgps;

{
	struct nmsg	nhead;			/* network msg header */
	struct _gps	*p;			/* ptr GPS entry */
	int		i;			/* favourite index */
/*
 * Set up the message.
 */
	nhead.nh_type = 0;
	nhead.nh_flags = DINT4MSG;
	nhead.nh_msg = (char *) pgps;
	nhead.nh_length = nprocs * sizeof(struct _gps);
/*
 * Loop sending to each process.
 */
	for (i = 0, p = pgps; i < nprocs; i++, p++) {
		nhead.nh_node = p->gps_node;
		nhead.nh_event = (-p->gps_pid) & 0xBFFFFFFF;

		if (nsend(&nhead)) return(LAMERROR);
	}
	
	return(0);
}

/*
 *	app_doom
 *
 *	Function:	- kill running application processes
 *	Accepts:	- GPS array length
 *			- application GPS array
 *	Returns:	- 0 or ERROR
 */
int
app_doom(int app_n, struct _gps *app, int sig)
{
	int		i;

	for (i = 0; i < app_n; i++) {
	    	if (app[i].gps_pid == 0) {
			break;
	    	}

		rpdoom(app[i].gps_node, SELECT_PID, app[i].gps_pid, sig);
	}

	return(0);
}
