/* 
 * $Copyright-c$ 
 *
 * $Id: endian.c,v 1.4 2000/10/18 21:47:22 jsquyres Exp $
 */

#include <lam_config.h>
#if LAM_WANT_IMPI

#include <stdio.h>

#include <t_types.h>
#include <impi.h>
#include <impi-defs.h>
#include <impid.h>


void
lam_swap_endian(void *buf, int size)
{
#if !WORDS_BIGENDIAN
  char temp[64];

  switch(size) {
  case 2:
    ttoli2(buf, temp);
    memcpy(buf, temp, 2);
    break;
  case 4:
    ttoli4(buf, temp);
    memcpy(buf, temp, 4);
    break;
  case 8:
    ttoli8(buf, temp);
    memcpy(buf, temp, 8);
    break;
  case 16:
    /* The only 16 byte swaps that we do are for the IPV6 addresses,
       which we manually paste the IPV4 address into the right nybbles
       anyway.  So make this a noop. */
    break;
  default:
    fprintf(stderr, "Unknown endian swap size: %d\n", size);
    break;
  }
#endif
}

#endif
