/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: fqstate.c,v 6.2 1999/06/12 17:11:30 kmeyer1 Exp $
 * 
 *	Function:	- FQSTATE request
 *			- a monitoring request with no associated file
 *			  operation
 */

#include <string.h>

#include "filed.h"
#include <freq.h>
#include <net.h>
#include <t_types.h>
#include <terror.h>

/*
 * external variables
 */
extern char		fbuf[];		/* general purpose message buffer */
extern struct fdesc	*fdtop;		/* top of descriptor list */

/*
 * external functions
 */
void			fsendr();	/* general purpose file reply */

/*
 *	fqstate
 *
 *	Function:	- sends back every file descriptor
 *	Accepts:	- filed request
 *			- assumes MAXNMSGLEN > sizeof(struct fdesc)
 */
void
fqstate(fq)

struct freq		*fq;

{
	struct fdesc	*f;		/* ptr to target descriptor */
	struct fstate	*p;		/* ptr to desc state */
	int4		n;		/* total space used in buf */

	p = (struct fstate *) fbuf;
	n = 0;

	for (f = fdtop; f != FDNULL; f = f->f_next) {
/*
 * If buffer is almost full, send it back to the client and reset.
 */
		if ((n + sizeof(struct fstate)) > MAXNMSGLEN) {
			fsendr(fq->fq_src_node, fq->fq_src_event,
					0, INT4_NIL, n, INT4_NIL);
			p = (struct fstate *) fbuf;
			n = 0;
		}
/*
 * Add to the buffer.
 */
		else {
			p->fs_tfd = ltot(f->f_tfd);
			p->fs_tflags = ltot(f->f_tflags);
			p->fs_flow = ltot(f->f_flow);
			p->fs_count = ltot(f->f_count);
			p->fs_src_node = ltot(f->f_src_node);
			p->fs_src_event = ltot(f->f_src_event);
			strcpy(p->fs_name, f->f_name);
			p += 1;
			n += sizeof(struct fstate);
		}
	}

	fsendr(fq->fq_src_node, fq->fq_src_event, EEOF, INT4_NIL, n, 0);
}
