/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: echod.c,v 1.3 2000/03/15 21:52:06 jsquyres Exp $
 * 
 *	Function:	- echo server
 *			- receives a message and echos it back to the sender
 *			- primarily a diagnostic tool
 *			- message size limited to MAXNMSGLEN
 */

#include <lam_config.h>

#include <string.h>

#include <events.h>
#include <ereq.h>
#include <net.h>
#include <preq.h>
#include <terror.h>

/*
 * local variables
 */
static char		msg[MAXNMSGLEN];	/* echo message */
static struct nmsg	nhead;			/* echo network message */

/*
 * global functions
 */
void			(*(e_init()))();
void			(*(echod()))();

/*
 *	e_init
 *
 *	Function:	- echod initialization
 */
void (*(
e_init()))()

{
/*
 * Attach to kernel.
 */
	if (lpattach("echod")) {
		lampanic("echod (lpattach)");
	}
/*
 * Receive first request.
 */
	LAM_ZERO_ME(nhead);
	memset((void*) msg, -1, MAXNMSGLEN);
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}

/*
 *	echod
 *
 *	Function:	- server loop
 *			- replies message & receives next request
 */
void
(*(echod()))()

{
	struct ereq	*request;		/* request from client */

	request = (struct ereq *) nhead.nh_data;
/*
 * Reply to the request.
 */
	nhead.nh_node = request->eq_node;
	nhead.nh_event = request->eq_event;
	nhead.nh_flags = NREEL;
	nhead.nh_msg = msg;

	if (nsend(&nhead)) {
		panic("echod (nsend)");
	}
/*
 * Receive a request.
 */
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}
