/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: bforward.c,v 1.3 2000/03/15 21:52:12 jsquyres Exp $
 * 
 *	Function:	- bforward, henchman of bufferd
 *			- forwards remote messages for bufferd
 */

#include <lam_config.h>

#include <string.h>

#include <bfreq.h>
#include <events.h>
#include <net.h>
#include <rreq.h>
#include <terror.h>

/*
 * local variables
 */
static char		buf[MAXNMSGLEN];
static struct nmsg	nhead;			/* network message */

/*
 * local functions
 */
static void		bwrecv();

/*
 * global functions
 */
void			(*(bw_init()))();
void			(*(bforward()))();

/*
 *	bw_init
 *
 *	Function:	- bforward initialization
 */
void (*(
bw_init()))()

{
/*
 * Receive first request.
 */
	LAM_ZERO_ME(nhead);
	memset((void*) buf, -1, MAXNMSGLEN);

	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bforward
 *
 *	Function:	- server loop
 *			- forwards message & receives next message
 */
void
(*(bforward()))()

{
/*
 * Don't forward the KTRY, DDLI or KTRACE flags.
 */
	nhead.nh_flags &= ~(KTRY | DDLI | KTRACE);

	if (getroute(&nhead)) lampanic("bforward (getroute)");

	if (dsend(&nhead)) lampanic("bforward (dsend)");
/*
 * Receive next message.
 */
	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bwrecv
 *
 *	Function:	- receives a message from bufferd
 */
static void
bwrecv()

{
	nhead.nh_event = EVBFORWARD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = buf;

	if (bfrecv(&nhead)) lampanic("bforward (bfrecv)");
}
