// -*- c++ -*-
//
// $Id: functions.cc,v 1.1.1.1.2.2 2001/10/29 04:33:14 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi++.h"

#if _MPIPP_PROFILING_

//
// Point-to-Point Communication
//

void 
MPI::Attach_buffer(void* buffer, int size)
{
  PMPI::Attach_buffer(buffer, size);
}

int 
MPI::Detach_buffer(void*& buffer)
{
  return PMPI::Detach_buffer(buffer);
}

//
// Process Topologies
//

void
MPI::Compute_dims(int nnodes, int ndims, int dims[])
{
  PMPI::Compute_dims(nnodes, ndims, dims);
}


//
// Environmental Inquiry
//

void 
MPI::Get_processor_name(char* name, int& resultlen)
{
  PMPI::Get_processor_name(name, resultlen);
}

void
MPI::Get_error_string(int errorcode, char* string, int& resultlen)
{
  PMPI::Get_error_string(errorcode, string, resultlen);
}

int 
MPI::Get_error_class(int errorcode) 
{
  return PMPI::Get_error_class(errorcode);
}

double 
MPI::Wtime()
{
  return PMPI::Wtime();
}

double 
MPI::Wtick()
{
  return PMPI::Wtick();
}

void
MPI::Init(int& argc, char**& argv)
{
  PMPI::Init(argc, argv);
}

void
MPI::Init()
{
  PMPI::Init();
}

void
MPI::Finalize()
{
  PMPI::Finalize();
}

MPI2CPP_BOOL_T
MPI::Is_initialized()
{
  return PMPI::Is_initialized();
}

//
// Profiling
//

void
MPI::Pcontrol(const int level, ...)
{
  va_list ap;
  va_start(ap, level);
 
  PMPI::Pcontrol(level, ap);
  va_end(ap);
}

#if MPI2CPP_HAVE_MPI_GET_VERSION
void
MPI::Get_version(int& version, int& subversion)
{
  PMPI::Get_version(version, subversion);
}
#endif

MPI::Aint
MPI::Get_address(void* location)
{
  return PMPI::Get_address(location);
}

#endif
