c
c Copyright 1998-2001, University of Notre Dame.
c Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
c          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
c 
c This file is part of the Notre Dame LAM implementation of MPI.
c 
c You should have received a copy of the License Agreement for the Notre
c Dame LAM implementation of MPI along with the software; see the file
c LICENSE.  If not, contact Office of Research, University of Notre
c Dame, Notre Dame, IN 46556.
c 
c Redistribution and use in source and binary forms, with or without
c modification, are permitted subject to the conditions specified in the
c LICENSE file.
c 
c THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
c IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
c WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
c DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
c INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
c (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
c SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
c HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
c STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
c IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
c POSSIBILITY OF SUCH DAMAGE.
c 
c Additional copyrights may follow.
c 
c
c	University of Notre Dame LAM
c	$Id: trivialf.f,v 6.1 2001/02/02 05:34:05 jsquyres Exp $
c
c	Transmit a message in a two process system.
c
	program trivial

        include 'mpif.h'

	integer*4 BUFSIZE

	parameter (BUFSIZE = 64)

	integer*4	buffer(BUFSIZE)
	integer		rank
	integer		size
	integer 	status(MPI_STATUS_SIZE)

c
c Initialize MPI.
c
	call MPI_INIT(ierror)
c
c Error check the number of processes.
c Determine my rank in the world group.
c The sender will be rank 0 and the receiver, rank 1.
c
	call MPI_COMM_SIZE(MPI_COMM_WORLD, size, ierror)

	if (size .lt. 2) then
		print *,'Need at least 2 processes.'
		call MPI_FINALIZE(ierror)
		stop
	endif

	call MPI_COMM_RANK(MPI_COMM_WORLD, rank, ierror)
c
c As rank 0, send a message to rank 1.
c
	if (rank .eq. 0) then
		call MPI_SEND(buffer(1), BUFSIZE, MPI_INTEGER,
     +				1, 11, MPI_COMM_WORLD, ierror)
		print *,'rank ',rank,' sent message'
c
c As rank 1, receive a message from rank 0.
c
	else if (rank .eq. 1) then
		call MPI_RECV(buffer(1), BUFSIZE, MPI_INTEGER,
     +				0, 11, MPI_COMM_WORLD, status, ierror)      
		print *,'rank ',rank,' received message'
	endif

	call MPI_FINALIZE(ierror)
	stop
	end
