dnl -*- shell-script -*-

#
# $Id: lam_check_stdc.m4,v 1.1 2000/10/17 12:05:17 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_CHECK_STDC,[
# Check to see if compiler sets __STDC__ to 1 or not
AC_MSG_CHECKING(for __STDC__)
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
#ifndef __STDC__
#define __STDC__ -1
#endif
int main(int argc, char* argv[])
{
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", __STDC__);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_stdc=`cat conftestval`
    AC_MSG_RESULT([$lam_ac_stdc])
    if test "$lam_ac_stdc" = "0"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__ to 1!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    elif test "$lam_ac_stdc" = "-1"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    fi
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])dnl

