/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: rpi.tcp.h.in,v 6.2 1999/04/01 21:38:54 kmeyer1 Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _RPI_TCP_H
#define _RPI_TCP_H

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define INITHASH	((int4) 59)		/* initial hash table size */
#define TCPSHORTMSGLEN	65536		/* max. length of short msg */

/*
 * structures
 *
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_sock;		/* socket descriptor */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_extra;		/* # bytes to go into sink */
	MPI_Request	cp_wreq;		/* req writing to process */
	MPI_Request	cp_rreq;		/* reading req */
	MPI_Request	cp_mreq;		/* req to match from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

#endif	/* _RPI_TCP_H */
