/* ./share/h/lam_config.h.  Generated automatically by configure.  */
/* -*- c -*-
 *
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	LAM configuation header file.
 *
 *	$Id: lam_config.h.in,v 1.39 1999/11/11 16:01:12 jsquyres Exp $
 *
 *	Function:	- OS, CPU and compiler dependent configuration
 */

#ifndef _LAM_CONFIG_H
#define _LAM_CONFIG_H

#define LAM_ARCH			"i686-pc-linux-gnu"
#define LAM_RPI				"tcp"

/*
 * Are we compiling under NT/Cygwin?
 */
#define LAM_CYGWIN			0

/*
 * Signal used internally by LAM.
 */
#define LAM_SIGUSR			SIGUSR2

/*
 * Choose the RPI. Set *ONE* of these to 1.
 */
#define LAM_RPI_TCP			1
#define LAM_RPI_SHM_SYSV		0
#define LAM_RPI_SHM_USYSV		0

/* 
 * Define as 1 if you have it. 
 * Slightly risky here -- only define this if is hasn't already been
 * defined.  Prevents redefinitions from other libraries (hopefully
 * they're set to the same value!)
 */
#ifndef HAVE_ATEXIT
#define HAVE_ATEXIT			1
#endif
#ifndef HAVE_GETCWD
#define HAVE_GETCWD			1
#endif
#ifndef HAVE_SNPRINTF
#define HAVE_SNPRINTF			1
#endif
#ifndef HAVE_ATOLL
#define HAVE_ATOLL			1
#endif
#ifndef HAVE_STRTOLL
#define HAVE_STRTOLL			1
#endif

#ifndef HAVE_SCHED_H
#define HAVE_SCHED_H			1
#endif
#ifndef HAVE_STROPTS_H
#define HAVE_STROPTS_H			1
#endif
#ifndef HAVE_GRP_H
#define HAVE_GRP_H			1
#endif
#ifndef HAVE_NETINET_TCP_H
#define HAVE_NETINET_TCP_H		1
#endif
#ifndef HAVE_RPC_TYPES_H
#define HAVE_RPC_TYPES_H		1
#endif
#ifndef HAVE_RPC_XDR_H
#define HAVE_RPC_XDR_H			1
#endif

/*
 * Some OS's are missing prototypes
 */
#define LAM_HAVE_snprintf_PROTO		1
#define LAM_HAVE_gethostname_PROTO	1
#if !LAM_HAVE_gethostname_PROTO
#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif
int gethostname(char *name, int namelen);
#if defined(c_plusplus) || defined(__cplusplus)
}
#endif
#endif

/*
 * Use to select for IMPI support or not
 */
#define LAM_WANT_IMPI                   0
#define WANT_IMPI                       LAM_WANT_IMPI

/*
 * Check the characteristics of our C++ compiler
 * Only do this if we're compiling IMPI!
 */
#if LAM_WANT_IMPI
#define LAM_HAVE_NOTHROW_NEW		0
#define LAM_NOTHROW_NEW			0
#define LAM_HAVE_EXCEPTIONS		0
#define LAM_HAVE_BOOL			0
#define LAM_HAVE_TRUE_FALSE		0
#if !LAM_HAVE_BOOL
/* If we do not have bool, we do not have true or false either */
typedef enum { false, true } bool;
#else
/* 
 * If we do have bool, we may or may not have true and false (!).
 * Can't just typedef true and false, though, because some compilers
 * will make typedef types as small as possible, which may not be the
 * same type/size as "bool" (e.g., if bool is and int) 
 */
#if !LAM_HAVE_TRUE_FALSE
bool false = (bool) 0;
bool true = (bool) 1;
#endif
#endif

#endif /* LAM_WANT_IMPI */

/*
 * Various LAM tests 
 */
#define LAM_HAVE_SA_RESTART		1
#define LAM_HAVE_SA_LEN			0
#define LAM_HAVE_UNION_SEMUN		0
#define LAM_HAVE_BSD43_FD_PASSING	0
#define LAM_HAVE_BSD44_FD_PASSING       1
#define LAM_HAVE_SYSV_FD_PASSING	1
#define LAM_HAVE_BSD_PTYS		1
#define LAM_HAVE_SYSV_PTYS		1

/* 
 * Define as 1 if have yield() or sched_yield() function.
 */
#ifndef HAVE_YIELD
#define HAVE_YIELD			0
#endif
#ifndef HAVE_SCHED_YIELD
#define HAVE_SCHED_YIELD		1
#endif

/* 
 * Define as 1 if you need it. 
 */
#define LAM_NEED_SYS_SELECT_H		0

/* 
 * Define as 1 if broken.
 */
#define LAM_BROKEN_SET_INET_SO_BUFSIZES 0
#define LAM_BROKEN_SET_UNIX_SO_BUFSIZES 0

/* 
 * Set *ONE* of these to 1 according to the format the FORTRAN compiler
 * uses for external names.
 */
#define LAM_FORTRANNOUNDERSCORE         0
#define LAM_FORTRANCAPS                 0
#define LAM_FORTRANUNDERSCORE           1
#define LAM_FORTRANDOUBLEUNDERSCORE     0        

/*
 * Predefined types
 */
#define LAM_HAVE_int2			0
#define LAM_HAVE_uint2			0
#define LAM_HAVE_int4			0
#define LAM_HAVE_uint4			0
#define LAM_HAVE_int8			0
#define LAM_HAVE_uint8			0
#define LAM_HAVE_float4			0
#define LAM_HAVE_float8			0

/*
 * Type sizes.
 * Very, very annoying because of standardized AC_CHECK_SIZEOF macro...
 */
#define LAM_SIZEOF_SHORT		2
#define LAM_SIZEOF_WCHAR		4
#define LAM_SIZEOF_INT			4
#define LAM_SIZEOF_LONG			4
#define LAM_SIZEOF_LONG_LONG		8
#define LAM_SIZEOF_FLOAT		4
#define LAM_SIZEOF_DOUBLE		8
#define LAM_SIZEOF_LONG_DOUBLE		12
#define LAM_SIZEOF_VOID_P		4

#define LAM_ALIGNMENT_SHORT	       	2
#define LAM_ALIGNMENT_WCHAR	       	4
#define LAM_ALIGNMENT_INT	       	4
#define LAM_ALIGNMENT_LONG	       	4
#define LAM_ALIGNMENT_LONG_LONG		4
#define LAM_ALIGNMENT_FLOAT	       	4
#define LAM_ALIGNMENT_DOUBLE		4
#define LAM_ALIGNMENT_LONG_DOUBLE	4
#define LAM_ALIGNMENT_VOID_P		4

#define LAM_SIZEOF_FORTRAN_INT		4
#define LAM_SIZEOF_FORTRAN_REAL		4
#define LAM_SIZEOF_FORTRAN_DBLPREC     	8
#define LAM_SIZEOF_FORTRAN_COMPLEX     	8
#define LAM_SIZEOF_FORTRAN_DBLCOMPLEX	16

#define LAM_ALIGNMENT_FORTRAN_INT	4
#define LAM_ALIGNMENT_FORTRAN_REAL	4
#define LAM_ALIGNMENT_FORTRAN_COMPLEX	8
#define LAM_ALIGNMENT_FORTRAN_DBLPREC	4
#define LAM_ALIGNMENT_FORTRAN_DBLCOMPLEX	8

/* 
 * Define as 1 if words are stored with the most significant byte first. 
 */
#define WORDS_BIGENDIAN			0

/*
 * See if we can use "const" or not
 */
#define CONST                           const

/* 
 * Define as 1 if floating point is IEEE.
 */
#define HAVE_IEEE_FP			1

/* 
 * Use select for spinlock yielding even when OS yield functionality is
 * available.
 */
#define LAM_USE_SELECT_YIELD		0

/*
 * Define to 1 if the struct stat elements are not int4's
 * Currently, this is only for the portland group compilers
 */
#define LAM_STAT_MEMBERS_INT4           0

/*
 * Define to 1 if we want ROMIO support
 * Some architectures need -laio in conjunction with ROMIO
 */
#define LAM_WANT_ROMIO                  0
#define HAVE_LIBAIO                     0

/*
 * Define to 1 if we want MPI 2 C++ bindings support
 */
#define LAM_WANT_MPI2CPP                1

/*
 * Some compilers do not define __STDC__ correctly (e.g., Solaris
 * workshop, at least version 4.2).  As such, the LAM header files
 * will not include full ANSI prototyping, which is a real pain for
 * users.  We can override that here -- set to 1 if you want full
 * ANSI prototypes.
 */
#define LAM_CONFIG_FORCE_PROTOS          1

#if __STDC__ || defined(c_plusplus) || defined(__cplusplus) || LAM_CONFIG_FORCE_PROTOS
#define LAM_WANT_PROTOS 1
#else
#define LAM_WANT_PROTOS 0
#endif

/*
 * prototypes
 */
#ifndef __ARGS
#if LAM_WANT_PROTOS
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

/*
 * Use to select if definitely want to zero out memory before using it.
 * This affects lower layers of message passing API, where purify, bcheck,
 * and other memory-checking debuggers will sometimes complain about
 * "read from uninitialized" and the like, when the code actually shows
 * that it is ok.  That is, LAM will function correctly with or without
 * this flag -- this flag only affects what purify/bcheck/etc. will report.
 * Note that there will be slightly more overhead in message passing if
 * this flag is enabled.
 */
#define LAM_DISINFECT                    0
#if LAM_DISINFECT
#define LAM_ZERO_ME(a) { \
int i; \
char *foo = (char*) &(a); \
for (i = 0; i < sizeof((a)); i++) foo[i] = 0; \
}
#else
#define LAM_ZERO_ME(a)
#endif

/*
 * In some places, we need to swap the endian (particularly in IMPI)
 */
#if LAM_WANT_IMPI
#if WORDS_BIGENDIAN
#define LAM_SWAP_ENDIAN(x, y)
#else
#define LAM_SWAP_ENDIAN(x, y) lam_swap_endian(x, y)
#endif
#endif

/*
 * Keep the compilers that were chosen in configure for use in the
 * wrapper compilers hcc, hcp, and hf77.  The C++ compiler is defined
 * in tools/hcc/hcp.in
 */

#define LAM_CC "gcc"
#define LAM_F77 "pgf90"

/*
 * Find out the right type for the option length parameter to
 * getsockopt() , and the length parameter in recvfrom().  #@%@#%@#
 * AIX!!!
 */
#define LAM_SOCK_OPTLEN_T	socklen_t
#define LAM_RECVFROM_LEN_T	socklen_t

#endif	/* _LAM_CONFIG_H */
