#!/bin/csh
#
mkdir temp
cd temp
rm *
f90split ../eispack.f90
#
foreach FILE (`ls -1 *.f90`)
  F90 -c $FILE >& compiler.txt
  if ( $status != 0 ) then
   echo "Errors while compiling " $FILE
    exit
  endif
  rm compiler.txt
end
rm *.f90
#
ar qc libeispack.a *.o
rm *.o
#
mv libeispack.a ~/lib/$ARCH
if ( $status != 0 ) then
  exit
endif
cd ..
rmdir temp
#
echo "Library installed as ~/lib/$ARCH/libeispack.a"
