#include<stdio.h>

double *Q0=NULL;
double *Q1=NULL;
double *Q2=NULL;

int* calcCoef=NULL;

static int indx_(int k,int l)
{
  int i,j;
  if(k<l) {i=k;j=l;}else{i=l;j=k;}
  return i+((j-1)*(j-2))/2 -1;
}

static void sprod_(double * momenta  )
{
    
    long i__1, i__2;
    int k;
    
    static long i, j;
    static long ntot;

    ntot = nin_ + nout_;
    i__1 = ntot - 1;
    for (i = 1; i <= i__1; ++i) 
    {
        i__2 = ntot;
        for (j = i + 1; j <= i__2; ++j) 
        { double *sum=DP+indx_(i,j);
          double *v1=momenta+4*(i-1);
          double *v2=momenta+4*(j-1);
          *sum=*v1**v2;
          for(k=1;k<=3;k++) (*sum)-=v1[k]*v2[k]; 
        }
    }   
} /* sprod_ */  


double sqrMom(char * momnum, double * lv)
{ char * ii;
  double s[4]={0,0,0,0};
  char nin_char;
  nin_char=nin_;
    
  ii=momnum;
  while(*ii)
  { int k;
    if(*ii>nin_char) for(k=0;k<4;k++) s[k]-=lv[k+4*(*ii-1)];
    else             for(k=0;k<4;k++) s[k]+=lv[k+4*(*ii-1)]; 
    ii++;
  }  
  return s[0]*s[0]-s[1]*s[1]-s[2]*s[2]-s[3]*s[3];    
}


static double simSqme(int nsub,double*momenta, char*particls,int ntot,int level,int*err)
{
  double ans;
  int    n,i;
  int  k;
  double buff;
    
  if (level==ntot){buff=smpl(nsub,momenta, err);calcCoef[nsub]=0;return buff; }

  ans=simSqme(nsub,momenta,particls,ntot,level+1,err);
  n=1;

  for ( i=level+1;i<=ntot;i++)
  {
     if (particls[i] ==particls[level]  ) 
     {  for(k=0;k<4;k++) 
        { buff=momenta[k+4*level-4];
          momenta[k+4*level-4]=momenta[k+4*i-4];
          momenta[k+4*i-4]=buff;
        }
        ans+=simSqme(nsub,momenta,particls,ntot,level+1,err);
        for(k=0;k<4;k++) 
        { buff=momenta[k+4*level-4];
          momenta[k+4*level-4]=momenta[k+4*i-4];   
          momenta[k+4*i-4]=buff;
        }
        n++;
     }
  } 

  return ans/n;
}


double sqme_(int nsub,double * momenta, int * err)
{
  char  particls[10], name[10], name_i[10], name_j[10];
  int ntot,i,j;
  double val;
  static double * amem=NULL;
  int recalc=0;
  
  if(!calcCoef)
  {
     if(!amem) free(amem);
     calcCoef=(int *) malloc(sizeof(int)*(nprc_+1));
     amem=(double*)malloc(sizeof(double)*(1+nvar_));
     for(i=1; i<=nvar_; i++)  vinf_(i,NULL,amem+i);
     recalc=1;
  } else
  for(i=1; i<=nvar_; i++)
  {
    vinf_(i,name,&val);
    if(strcmp("GG",name) &&  val != amem[i]) {amem[i]=val; recalc=1;}
  }

  if(recalc)
  { 
    *err=calcFunc();
    if(*err) { *err=1; return 0;}
    for(i=1; i<=nprc_; i++)  calcCoef[i]=1; 
  } 
  
  ntot=nin_+nout_;

  for(i=1;i<=ntot;i++) particls[i]=i;
  
  for(i=1;i<ntot;i++) if (particls[i]==i)
  { pinf_(nsub,i, name_i,NULL);
    for(j=i+1;j<=ntot;j++)if (particls[j]==j)
    { pinf_(nsub,j,name_j,NULL);
      if(strcmp(name_i,name_j)==0) particls[j]=i;
    }
  }
  return  simSqme(nsub,momenta,particls,ntot,nin_+1,err);
} 
