      BLOCK DATA BEAM
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/ISR1/SCALE,XYnm,Zmm,Qtot,iON
      DATA SCALE/100/, iOn/0/ ,XYnm/560/, Zmm/0.4/, Qtot/2.E10/ 
      END


      FUNCTION BS_H(ETAX,BNcl)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
*      write(*,*)ETAX,BNcl

      G1_3=           1.d0/2.678938534707740      
      G2_3= ETAX**(1.d0/3)/1.354117939426404D0/2
      G3_3= ETAX**(2.d0/3)/6

      S0=G1_3*GAMMAI(2,BNcl)+ G2_3*GAMMAI(3,BNcl)+G3_3*GAMMAI(4,BNcl)
      N=3

1     N=N+1
      G1_3= 3*G1_3*ETAX/(N*(N-1)*(N-2)*(N-3))
      DS=G1_3*GAMMAI(N+1,BNcl)      
      N=N+1
      G2_3= 3*G2_3*ETAX/(N*(N-1)*(N-2)*(N-3))
      DS=DS+G2_3*GAMMAI(N+1,BNcl)
      N=N+1
      G3_3= 3*G3_3*ETAX/(N*(N-1)*(N-2)*(N-3))
      DS=DS+G3_3*GAMMAI(N+1,BNcl)
  
      S0=S0+DS
      IF(DS.GT.1.E-8*S0) GOTO 1
      BS_H=S0
*        write(*,*) 'BS_H=',BS_H
      RETURN
      END

      FUNCTION  CFbeam(X)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/ISR2/BETA,COEF,B_Ncl,B_ips

      CFbeam=0
      IF(X.LE.0.D0)  RETURN
      ETAX= 2/(3*B_ips)*(1/X-1)
      IF(ETAX.GT.50) RETURN
      CFbeam=(2/(3*B_ips))**(1.d0/3)*EXP(-ETAX)/(X**(4.d0/3 ))
     &      *BS_H(ETAX,B_Ncl)
      RETURN
      END
      


      FUNCTION  CFb_m_(Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        CFb_m_=CFbeam(EXP(-Y))*DIVY(Y)**(1.D0/3 -1)
      RETURN
      END

      FUNCTION  CFisr(X)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/ISR2/BETA,COEF,B_Ncl,B_ips
        CFisr=COEF*((1+X**2)-BETA*(log(X)*(1+3*X**2)/2+(1-X)**2)/2)/2
      RETURN
      END


      FUNCTION  CFisr_(Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/ISR2/BETA,COEF,B_Ncl,B_ips
        CFisr_=CFisr(EXP(-Y))*DIVY(Y)**(BETA-1)
      RETURN
      END

      SUBROUTINE FiISR2
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/ISR1/SCALE,XYnm,Zmm,Qtot,iON
      COMMON/ISR2/BETA,COEF,B_Ncl,B_ips
      COMMON /SQS/ SQRTS
      DOUBLE PRECISION mmToGeV
      DATA EGAM/0.5772156649d0/
      DATA mmToGeV/5.067E12/
      DATA EM/0.51099906d-03/
      DATA ALPHA/0.00729735/
      DATA PI/3.14159265358979323846/


      BETA   = ALPHA/PI*(2.d0*LOG(SCALE/EM)-1.d0)
      COEF=EXP(BETA*(0.75d0-EGAM))/DGAMMA(1+BETA)
      IF(iON.EQ.1) THEN  
      B_Ncl=  25*alpha**2*Qtot/(12*EM*(XYnm*1.E-6)*mmToGeV)
      B_ips=5*alpha*Qtot*SQRTS/(12*EM**3*Zmm*(XYnm*1.E-6)*mmToGeV**2)
*      B_Ncl=1.5
*      B_ips=0.03
      ENDIF      
      return 
      write(*,*)  'XYnm, Zmm, Qtot: ', XYnm ,Zmm, Qtot
      write(*,*)'beta ',BETA  
      write(*,*)'coeff',COEF
      write(*,*)'Ncl  ',B_Ncl
      write(*,*)'ips  ',B_ips 
      END



      SUBROUTINE INITISR(XI,YI,NNN)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XI(500),YI(500)

      COMMON/ISR1/SCALE,XYnm,Zmm,Qtot,iON
      COMMON/ISR2/BETA,COEF,B_Ncl,B_ips
      COMMON /SQS/ SQRTS


      EXTERNAL CFisr_,CFb_m_
      DATA NNN_/-1/
      SAVE

      IF((SCALE.EQ.SCALE_).AND.(iON.EQ.iON_).AND.(XYnm.EQ.XYnm_).AND.
     &(Zmm.EQ.Zmm_).AND.(Qtot.EQ.Qtot_).AND.(NNN.EQ.NNN_).AND.
     &(SQRTS.EQ.SQRTS_)) RETURN
      
      SCALE_=SCALE
      iON_=iON
      XYnm_=XYnm
      Zmm_=Zmm
      Qtot_=Qtot
      NNN_=NNN
      SQRTS_=SQRTS

      CALL FiISR2

      DO 100 I=1,NNN
        XI(I)= Dfloat(I-1)/NNN
        xx=1-XI(I)**3
        YI(I)=CFisr(xx)
        IF((iON.NE.0).AND.(B_Ncl.NE.0)) THEN
          EPS=1.E-6
          B2=1.d0/3
          XL=-LOG(xx)
          YI(I)=( YI(I)*(1-EXP(-B_Ncl)) + 
     &           (1-xx)**B2*DIVY(XL)**(1-BETA-B2)*
     &           CONVOL(CFb_m_,CFisr_,B2,BETA,XL,EPS)
     &          )/B_Ncl
        
        ENDIF
*       write(*,*) I,'x=',XI(I),' y=',YI(I) ,'eps=',eps 
100   CONTINUE
      END
