      REAL*8 FUNCTION CALCUT()
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL MINON,MAXON
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)


      CALCUT=1
      I=1

1     IF (KEY(I).EQ.0) RETURN
     
      XX=XPARAM(KEY(I),LVINVC(1,I))
    
      IF(MINON(I).AND.(XX.LT.CVMIN(I))) THEN
        CALCUT=0
        RETURN
      ENDIF

      IF(MAXON(I).AND.(XX.GT.CVMAX(I))) THEN
        CALCUT=0
        RETURN
      ENDIF
     
      I=I+1
      GOTO 1
      END


      SUBROUTINE INICUT
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL MINON,MAXON 
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      KEY(1)=0
      RETURN
      END
    

      SUBROUTINE DELCUT(NCUT)      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL MINON,MAXON 
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      IF(NCUT.LE.0) GOTO 40       
      DO 10 I=1,NCUT    
10    IF (KEY(I).EQ.0) RETURN
      I=NCUT
20    I1=I+1
      J=1 
30    NP=LVINVC(J,I1)
      LVINVC(J,I)=NP
      IF (NP.NE.0) THEN
         J=J+1
         GOTO 30           
      ENDIF
      KEY(I)  =KEY(I1)
      MINON(I)=MINON(I1)
      MAXON(I)=MAXON(I1)
      CVMIN(I)=CVMIN(I1)
      CVMAX(I)=CVMAX(I1)
      IF (KEY(I).EQ.0) RETURN
      I=I+1
      GOTO 20
      
40    RETURN
      END 
      

      SUBROUTINE CHNCUT(NCUT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)      
      LOGICAL MINONW,MAXONW
      LOGICAL MINON,MAXON,VALCUT  
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      IF(NCUT.LE.0)RETURN
      DO 10 I=1,NCUT    
10    IF (KEY(I).EQ.0) RETURN

      IF( VALCUT(KEY(NCUT),MINONW,MAXONW,CVMINW,CVMAXW)) THEN
         MINON(NCUT)=MINONW
         MAXON(NCUT)=MAXONW
         CVMIN(NCUT)=CVMINW
         CVMAX(NCUT)=CVMAXW 
      ELSE
        WRITE(*,*) 'Incorrect input'
        READ(*,*)
      ENDIF
      RETURN
      END
      
      
      SUBROUTINE ADDCUT(KE,LV,MINONW,MAXONW,CVMINW,CVMAXW)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)            
      LOGICAL MINON,MAXON        
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)

      LOGICAL MINONW,MAXONW,EQVE
      DIMENSION LV(10)

      IF(CHAR(KE).EQ.'M') THEN
         KE=ICHAR('S')
         IF(MINONW) CVMINW=CVMINW*ABS(CVMINW)
         IF(MAXONW) CVMAXW=CVMAXW*ABS(CVMAXW)
      ENDIF 
      NCUT=1
10    IF((KEY(NCUT).NE.0).AND.((KEY(NCUT).NE.KE).OR.
     &(.NOT.EQVE(LV,LVINVC(1,NCUT))))) THEN
         NCUT=NCUT+1
         GOTO 10
      ENDIF
      IF (NCUT.GE.60) RETURN
      J=1 
30    NP=LV(J)
      LVINVC(J,NCUT)=NP
      IF (NP.NE.0) THEN
         J=J+1
         GOTO 30           
      ENDIF
      IF(KEY(NCUT).EQ.0) THEN 
         KEY(NCUT+1)=0
         KEY(NCUT)  =KE
         MINON(NCUT)=MINONW
         MAXON(NCUT)=MAXONW
         CVMIN(NCUT)=CVMINW
         CVMAX(NCUT)=CVMAXW 
      ELSE
         IF(MINONW) THEN
            IF(MINON(NCUT)) THEN
                CVMIN(NCUT)=MAX(CVMINW,CVMIN(NCUT))
            ELSE
                MINON(NCUT)=.TRUE.
                CVMIN(NCUT)=CVMINW
            ENDIF
         ENDIF

         IF(MAXONW) THEN
            IF(MAXON(NCUT)) THEN          
                CVMAX(NCUT)=MIN(CVMAXW,CVMAX(NCUT))
            ELSE
                MAXON(NCUT)=.TRUE.
                CVMAX(NCUT)=CVMAXW
            ENDIF
         ENDIF
      ENDIF

      IF(MAXON(NCUT).AND.MINON(NCUT).AND.
     & (CVMAX(NCUT).LE.CVMIN(NCUT)))  THEN
      WRITE(*,*)'All phase space points are killed by cut number',NCUT 
      READ(*,*) 
      ENDIF
      RETURN
      END
      

      SUBROUTINE VIEWCT
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER PTXT*10,doll*2
      common /doll/ doll
      LOGICAL MINON,MAXON  
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      CHARACTER*20 CH_MIN,CH_MAX
      CHARACTER*3 CHNUM
      CHARACTER*8 UNIT
      IF (KEY(1).EQ.0) THEN
        WRITE(*,*) '***********  No  cuts *********** '
        WRITE(*,*)
        RETURN
      ENDIF   
      WRITE(*,1001)
1001  FORMAT(1X,26('-'),' C U T S ',26('-') )
      WRITE(*,1002)
1002  FORMAT(1X,'|  N |    MIN VALUE      |   PARAMETER   |',
     &'   MAX VALUE       |')

      WRITE(*,1004)
1004  FORMAT(1X, 61('-') )     

      I=1
10    IF (KEY(I).EQ.0) THEN
         WRITE(*,1005)
1005     FORMAT(1X,61('-')) 
         WRITE(*,*)
         RETURN
      ENDIF
      
      CALL WRPARM(PTXT, KEY(I), LVINVC(1,I))
      
      IF(MINON(I)) THEN
        VAL_MIN=CVMIN(I)
        IF(CHAR(KEY(I)).EQ.'S') THEN
          IF(VAL_MIN.GE.0)  THEN
             WRITE(CH_MIN,FMT='('' ('',1PE9.3,'' GeV)**2<'')')         
     &                SQRT(VAL_MIN)
          ELSE
             WRITE(CH_MIN,FMT='(''-('',1PE9.3,'' GeV)**2<'')')        
     &                SQRT(-VAL_MIN)
          ENDIF
        ELSE
          WRITE(CH_MIN,FMT='(1PE10.3,A8,'' <'')') VAL_MIN,
     &    UNIT(CHAR(KEY(I)))
        ENDIF
        
      ELSE
        CH_MIN='                   |'
      ENDIF

      IF(MAXON(I)) THEN
        VAL_MAX=CVMAX(I)
        IF(CHAR(KEY(I)).EQ.'S') THEN
          IF(VAL_MAX.GE.0) THEN
             WRITE(CH_MAX,FMT='(''< ('',1PE9.3,'' GeV)**2'')') 
     &             SQRT(VAL_MAX)
          ELSE
             WRITE(CH_MAX,FMT='(''<-('',1PE9.3,'' GeV)**2'')') 
     &             SQRT(-VAL_MAX)
          ENDIF
        ELSE
          WRITE(CH_MAX,FMT='(''<'',1PE10.3,A8)') VAL_MAX,
     &    UNIT(CHAR(KEY(I)))
        ENDIF
        
      ELSE
        CH_MAX='|                   '
      ENDIF


      IF(I.LT.10) THEN  
          CHNUM=CHAR(I+ICHAR('0'))
      ELSE
          CHNUM=CHAR(I-10+ICHAR('A'))
      ENDIF 
 
      WRITE(*,1006) CHNUM,CH_MIN,PTXT,CH_MAX
1006  FORMAT(1X,'|',A3,' |',A20,A15,A20,'|') 

            
25    CONTINUE
      I=I+1
      IF (MOD(I,17).EQ.16) THEN
         WRITE(*,FMT='(1x,''Press ENTER to continue'''//doll//')')    
         READ(*,*)         
      ENDIF
      GOTO 10
      
      END 


      LOGICAL FUNCTION  VALCUT(KEY,MINW,MAXW,VMIN,VMAX)
      DOUBLE PRECISION VMIN,VMAX
      LOGICAL MINW,MAXW
      CHARACTER doll*2, CKEY*1,UNIT*8
      common /doll/ doll

      CKEY=CHAR(KEY)       
      MINW=.TRUE.
 
      IF(CKEY.EQ.'S') THEN
        WRITE(*,FMT='(1X,''Enter MIN limit for S/sqtr(abs(S)) [GeV] '''
     &//doll//')') 
      ELSE 
        WRITE(*,FMT='(1X,''Enter MIN limit '',A8,1x'//doll//')')
     & UNIT(CKEY)
      ENDIF

      READ(*,FMT='(G15.0)',ERR=30 ) VMIN
      IF(CKEY.EQ.'S') VMIN=VMIN*ABS(VMIN)
      GOTO 31
30    MINW=.FALSE.
31    CONTINUE


      MAXW=.TRUE.

      IF(CKEY.EQ.'S') THEN
        WRITE(*,FMT='(1X,''Enter MAX limit for S/sqtr(abs(S)) [GeV] '''
     &//doll//')') 
      ELSE 
        WRITE(*,FMT='(1X,''Enter MAX limit '',A8,1X'//doll//')')
     & UNIT(CKEY)
      ENDIF

      READ(*,FMT='(G15.0)',ERR=40 ) VMAX
      IF(CKEY.EQ.'S')  VMAX=VMAX*ABS(VMAX) 
      GOTO 41
40    MAXW=.FALSE.
41    CONTINUE

      VALCUT=.TRUE.
      IF ( MINW.AND.MAXW.AND.(VMIN.GE.VMAX))  VALCUT=.FALSE.
      IF (.NOT.(MINW.OR.MAXW) )   VALCUT=.FALSE.

      RETURN
      END


      SUBROUTINE NEWCUT
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL MINW,MAXW
      CHARACTER DOLL*2
      COMMON /DOLL/ DOLL
      DIMENSION LV(21)
      LOGICAL RDPARM,VALCUT
      CHARACTER*10 BUFF
         
        WRITE(*,FMT='(1X,''Enter parameter: '''// doll//')')
        READ(*,FMT='(A10)') BUFF

        IF( RDPARM(BUFF,KEY,LV).AND.VALCUT(KEY,MINW,MAXW,VMIN,VMAX))
     &  THEN    
           CALL ADDCUT(KEY,LV,MINW,MAXW,VMIN,VMAX)
         ELSE
           WRITE(*,*) 'Incorrect input!'
           READ(*,*)
         ENDIF           

      END

      SUBROUTINE WRTCUT(NCHAN)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL MINON,MAXON  
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      SAVE 
      CHARACTER*17 AMIN,AMAX
      CHARACTER*10 CHRPAR
      CHARACTER*3 TXT1,TXT2
      LOGICAL LL,RDPARM
      N=1
10    IF ( KEY(NEXTNN(N)).NE.0) GOTO 10   
      N=N-2
      WRITE(NCHAN,110) N, ' cuts are introduced' 

      DO 50 I=1,N

        IF(MINON(I)) THEN
             WRITE(AMIN,FMT='(1PE17.10)') CVMIN(I)
        ELSE 
             AMIN='OFF'
        ENDIF
       
        IF(MAXON(I)) THEN
             WRITE(AMAX,FMT='(1PE17.10)') CVMAX(I)
        ELSE 
             AMAX='OFF'
        ENDIF

        CALL WRPARM(CHRPAR, KEY(I), LVINVC(1,I) )         

50       WRITE(NCHAN,120) AMIN , ' < ' ,CHRPAR,' < ',AMAX
      RETURN
      

110   FORMAT(1X,I2,A20)
120   FORMAT(1X,A17,A3,A10,A3,A17)


      ENTRY RDRCUT(NCHAN)
      READ(NCHAN, 110) N 
      DO 60 I=1,N
        READ(NCHAN,120) AMIN ,TXT1, CHRPAR, TXT2,AMAX
        

        IF(AMIN.EQ.'OFF') THEN
           MINON(I)=.FALSE.
        ELSE
           MINON(I)=.TRUE.
           READ(AMIN,FMT='(1PE17.10)') CVMIN(I)
        ENDIF

        IF(AMAX.EQ.'OFF') THEN
           MAXON(I)=.FALSE.
        ELSE
           MAXON(I)=.TRUE.
           READ(AMAX,FMT='(1PE17.10)') CVMAX(I)
        ENDIF

        LL=RDPARM(CHRPAR,KEY(I),LVINVC(1,I))
60     CONTINUE
        KEY(N+1)=0
  
      RETURN
      END
      
      FUNCTION NCUT(LV)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)            
      LOGICAL MINON,MAXON        
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)

      LOGICAL EQVECT
      DIMENSION LV(10)
       
      CALL CONINV(LV)
      NCUT=1
10    IF((KEY(NCUT).NE.0).AND.
     &(KEY(NCUT).NE.ICHAR('S').OR.(.NOT.EQVECT(LV,LVINVC(1,NCUT)))))
     &THEN
         NCUT=NCUT+1
         GOTO 10
      ENDIF
      IF (KEY(NCUT).EQ.0) NCUT=0 
C        WRITE(*,*) "NCUT=", NCUT
      
      RETURN
      END
      
      SUBROUTINE RANCOR(VMIN,VMAX,SHIFT,FMULT,N)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)            
      LOGICAL MINON,MAXON        
      COMMON/CUTS/ KEY(60),LVINVC(10,60),MINON(60),MAXON(60),
     &CVMIN(60),CVMAX(60)
      IF (N.EQ.0) RETURN

      IF (MINON(N)) THEN
         VNEW=(CVMIN(N)-SHIFT)*FMULT
         IF (FMULT.GT.0) THEN
            VMIN=DMAX1(VMIN,VNEW)
         ELSE
            VMAX=DMIN1(VMAX,VNEW)
         ENDIF   
      ENDIF
      
      IF (MAXON(N)) THEN
         VNEW=(CVMAX(N)-SHIFT)*FMULT
         IF (FMULT.GT.0) THEN
            VMAX=DMIN1(VMAX,VNEW)
         ELSE
            VMIN=DMAX1(VMIN,VNEW)           
         ENDIF   
      ENDIF
      
      RETURN
      END
