*************************************************************************
*   This function calculates MS-bar running ALPHAS.                     *                                    *
*            Ref: PDG-96   (Phys. Rev. D54, N1, 1996) p.77.             *
*   in NNLO approximation.                                              *
*                                                                       *
*   Quark masses thresholds are matched at                              *
*        Mc=1.3 GeV, Mb=4.3 GeV   (MS-bar masses)                       *
*     and Mtop=175 GeV                                                  *
*                                                                       *
*   Normalization by default:                                           *
*    ALPHAS(MZ)=0.1220 at MZ=91.1884 GeV (average LEP/LCD data, PDG-96) * 
*                                                                       *
*   Input parameter: DSCALE = QCD scale in GeV   (see function SCALE)   *
*   Input from common block:                                            *
*          QCDL6 =  Lambda at NF=6                                      *
*************************************************************************

      DOUBLE PRECISION FUNCTION ALPHAS2(DSCALE)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON/QCDGG/ QCDL6,NL
*  Lambda_QCD of different number of flavours 
      DIMENSION QCDLF(6)
*  beta-function coefficients 
      COMMON /BETA/ BETA0(6),BETA1(6),BETA2(6)
      LOGICAL FIRST
      DATA FIRST/.TRUE./
      SAVE

      NL=3
*** initialization
      IF ((FIRST).OR. (QCDL6.NE. QCDLF(6)) .or. NL.NE.NLL) THEN
         NLL = NL
         PI4=16.0D0*ATAN(1.d0)
* BETA initialization (no NF matching for light quarks)
         DO 5 NFF=1,6
           QCDLF(NFF) = 0.d0
           BETA0(NFF) = 0.d0
           BETA1(NFF) = 0.d0
           BETA2(NFF) = 0.d0
5        CONTINUE
         QCDLF(6)= QCDL6
* evaluation of necessary BETA coefficients
         DO 10 NFF=3,6
           BETA0(NFF)= 11.d0 - 2.d0/3.d0*NFF
           IF(NLL.GE.2) BETA1(NFF)= 51.d0 -19.d0/3.d0*NFF
           IF(NLL.EQ.3) BETA2(NFF)= 
     &           2857.d0-5033.d0/9.d0*NFF+325.d0/27.d0*NFF**2
10       CONTINUE
c...serach for quark masses in CompHEP session parameters:
         XMC = 1.3d0
         XMB = 4.3d0
         XMTOP = 175.d0

* matching t-quark threshold (LO formula)
         QCDLF(5)=TONF(QCDLF(6),XMTOP,6)
c         write(*,*) 'Lambda(5)=',qcdlf(5)
* matching b-quark threshold 
         QCDLF(4)=TONF(QCDLF(5),XMB,5)
c         write(*,*) 'Lambda(4)=',qcdlf(4)
* matching c-quark threshold 
         QCDLF(3)=TONF(QCDLF(4),XMC,4)
c         write(*,*) 'Lambda(3)',qcdlf(3)
* end of the initialization
         FIRST=.FALSE.
      ENDIF

      IF     (DSCALE .GT. XMTOP) THEN
          NF = 6
      ELSEIF (DSCALE .GT. XMB) THEN
          NF = 5
      ELSEIF (DSCALE .GT. XMC) THEN
          NF = 4
      ELSE
          NF = 3
      ENDIF

c...LO 
      B0 = BETA0(NF)
      RL = 2.d0*LOG(DSCALE/QCDLF(NF))
      ALPHAS2 = PI4/(B0*RL)
c...LO 
      IF (NLL.GE.2) THEN
        B1 = BETA1(NF)
        ALPHAS2 = ALPHAS2*(1-2*B1/B0**2*LOG(RL)/RL )
c...NNLO
        IF (NLL.EQ.3) THEN
          IF (DSCALE.LE.QCDLF(NF)) THEN
            WRITE(*,*) 'NNLO ALPHAS failed: DSCALE<QCDLF(',NF,')'
            STOP
          ENDIF
          B2 = BETA2(NF)
          ALPHAS2 = ALPHAS2 + PI4/(B0*RL)*(
     &         4.d0*B1**2/(B0**4*RL**2)*((LOG(RL)-0.5d0)**2
     &        +B2*B0/(8*B1**2) - 5.d0/4.d0)
     &                                )
        ENDIF
      ENDIF
      RETURN
      END

****************************************************
*  NF matching of Lambda_QCD                       *      
****************************************************
      DOUBLE PRECISION FUNCTION TONF(QCDL,XMQ,NF)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /BETA/ B0(6),B1(6),B2(6)
    
      RL = LOG(XMQ/QCDL)
      B10N  = B1(NF)/B0(NF)
      B10N1 = B1(NF-1)/B0(NF-1)

        IF (XMQ.LE.QCDL) THEN
          WRITE(*,*) 'NNLO MQ matching failed: MQ<QCDL:',XMQ,QCDL
          STOP
        ENDIF

        TONF = QCDL*EXP(-1/B0(NF-1)
     &   *( (B0(NF)-B0(NF-1))*RL
     &     +(B10N-B10N1)*LOG(2*RL)
     &     -B10N1*LOG(B0(NF)/B0(NF-1)) 
     &     +( B10N*(B10N-B10N1)*LOG(2.d0*RL)
     &       +B10N**2-B10N1**2
     &       -B2(NF)/2.d0/B0(NF)+B2(NF-1)/2.d0/B0(NF-1)-7.d0/18.d0
     &      )/(B0(NF)*RL)
     &    )              )

      RETURN
      END


      SUBROUTINE QCDMEN
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER     PROCES*30
      COMMON /PROCES/  NSUB,PROCES
      COMMON/QCDGG/ QCDL6,NL
      COMMON /NSCALE/ RVAL, LIST(10)
      CHARACTER*25 CHQ2,CHALPH
      CHARACTER*15 CHQCDL6
      CHARACTER*1 CHNL
      CHARACTER*3 CHMOM 
      CHARACTER*500 STRMEN     

10    CALL CLRSCR
      WRITE(CHNL,FMT='(I1)') NL
      WRITE(CHQCDL6,FMT='(G11.4)') QCDL6         
      IF(LIST(1).EQ.0) THEN
         WRITE(CHQ2,FMT='(A1,1PE12.5,A7)') '(',RVAL,'GeV)**2'
      ELSE 
         CHQ2='('
         N=1         
21       CHQ2(3*N-1:3*N+1)= CHMOM(LIST(N)) 
         N=N+1
         IF(LIST(N).NE.0) GOTO 21
         CHQ2(3*N-1:3*N+2)=')**2'
      ENDIF

      IF (LIST(1).EQ.0) THEN
        WRITE(CHALPH,FMT='(A7,G11.4)') 
     &      'ALPHAS=', ALPHAS2(RVAL)
c       write (*,*) alphas2(rval),rval,qcdl6,nl
      ELSE
          CHALPH=' ALPHAS running '
      ENDIF 

145    continue  
       STRMEN = '% ALPHAS menu!'//PROCES//'!'//CHALPH//     
     &    '!%Lambda(6) = '//CHQCDL6//
     &    '!Q2         =  '//CHQ2  //'!!!'

      MODE=MENU(STRMEN,'n_qcd_')
      IF (MODE.EQ.0) THEN
        IF(LIST(1).EQ.0) CALL ALF
        RETURN
      ELSEIF (MODE.EQ.1) THEN 
        WRITE(*,FMT='('' QCD Lambda(6) = '',$)') 
           READ(*,*)  QCDL6
      ELSEIF (MODE.EQ.2) THEN
22       WRITE(*,*) 
     &  'input: N<number> (constant Q^2),  L<invariant>  (running Q^2)'
         READ(*,FMT='(A20)') CHQ2
         IF ((CHQ2(1:1).EQ.'N').or.(CHQ2(1:1).EQ.'n')) THEN
            READ( CHQ2(2:20)  ,FMT='(F19.0)',ERR=29)  RVAL
            RVAL=ABS(RVAL)        
            LIST(1) = 0 
         ELSE 
            DO 23 LL=1,10
23          LIST(LL)=0
            LL=2
            DO 24 LL=2,20
24             IF(CHQ2(LL:LL).NE.' ') GOTO 25
            GOTO 29
25          READ(CHQ2(LL:20),FMT='(10I1)',ERR=29) LIST
            CALL ORDINV(LIST)
            CALL CONINV(LIST)
         ENDIF
         GOTO 30
29       IF(LIST(1).EQ.0) THEN 
            WRITE(*,*) 'input error '
            GOTO 22
         ENDIF  
30       CONTINUE           
      ELSE
        CONTINUE
      ENDIF
      GOTO 10

      END 
     

***************************************************
*   Write user parameters in the file SESSION.DAT *
***************************************************
      SUBROUTINE W_QCD(MODE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER XXX*80
      COMMON /NSCALE/ RVAL, LIST(10)
      COMMON /QCDGG/QCDL6,NL
      SAVE      
* write first (prompt) line
      XXX='========  QCD  parameters ==========='
      WRITE(MODE,100) XXX
      WRITE(MODE,104) 'Q**2                :   ',RVAL,LIST
c      WRITE(MODE,101) 'Approx.(LO=1,NLO=2,NNLO=3):   ',NL
      WRITE(MODE,102) 'Lambda(6)           :   ',QCDL6
      RETURN
      
*********************************************
*   Initialization of user parameters       *
*********************************************
      ENTRY I_QCD
      XXX='========  QCD  parameters ==========='
      NL=3
      QCDL6=0.1185
      RVAL=91.1884
      DO 11 I=1,10 
11      LIST(I)=0
      RETURN

****************************************************
*   Read user parameters from the file SESSION.DAT *
****************************************************
      ENTRY R_QCD(MODE)
* read first (prompt) line
      READ(MODE,100)  XXX
      READ(MODE,104) XXX,RVAL,LIST  
c      READ(MODE,101) XXX,NL
      READ(MODE,102) XXX,QCDL6
      RETURN
100   FORMAT(1X,A78)
101   FORMAT(1X,A30,i1)
102   FORMAT(1x,A24,g11.4)
104   FORMAT(1x,A24,E13.6,1x,10I2)
      END


      FUNCTION CHMOM(I)
      CHARACTER*3 CHMOM
      IF (I.LT.0) THEN 
          CHMOM(1:1)='-'
      ELSE
          CHMOM(1:1)='+'
      ENDIF
      CHMOM(2:2)='p'
      WRITE(CHMOM(3:3),FMT='(I1)') ABS(I)
      RETURN
      END

**********************************************************************
*    This subroutine is called during the phase space integration    *
*      (during the VEGAS run) for each phase space point after       *
*      calculation particles momenta and just before calculation of  *
*      structure functions and squared matrix element.               *
*                                                                    *
*    It is used, for example, to provide running ALPHAS.             *
*    This routine assumes standard notation                          *
*                           GG                                       *
*      for QCD coupling.                                             *
**********************************************************************
      SUBROUTINE ALF
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER NAME*6,XNAME*6

******* search for QCD coupling constant among process parameters
      NAME='GG'
      XNAME=' '
      DO 10 K=1,NVAR()  
        CALL VINF(K,XNAME,XVAL)
        IF (NAME.EQ.XNAME) GOTO 20
10    CONTINUE
      GOTO 100
20    DSCALE=1.D0
*** evaluate current transfered momentum scale
      CALL QSCALE(DSCALE)
*** evaluate running ALPHAS 
      ALFAS=ALPHAS2(DSCALE)
*** calculate new value of GG
      XVAL = SQRT(16*ATAN(1.d0)*ALFAS)
*** assign new value of GG
      CALL ASGN(K,XVAL)

100   RETURN
      END


**************************************************************
*   This subroutine is call to evaluate the transfered       *
*     momentum scale of the process - could be necessary for *
*     structure function interface, and is used for running  *
*     ALPHAS.                                                *
**************************************************************
      SUBROUTINE QSCALE(DSCALE)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON /NSCALE/ RVAL, LIST(10)

      IF (LIST(1).EQ.0) THEN
         DSCALE=RVAL
      ELSE          
         NVBUFF=NIN()+NOUT()+3
         CALL LVTONV(LIST,NVBUFF)
         DSCALE= SQRT(ABS(VDOT4(NVBUFF,NVBUFF)))
      ENDIF

      IF (DSCALE.LT.0.3) DSCALE=0.3
       
      RETURN
      END
