/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "os.h"
#include "chep_crt.h"
#include "files.h"
#include "plot.h"


int main(int argc,char** argv)
{   /*  MAIN - COMPHEP  */

 char   procName[100],xName[60],yName[60];
 double xMin,xMax;
 double *f=NULL, *df=NULL;
 int dim;
 int i; 
 int n;
 char icon_name[STRSIZ];

   strcpy(_pathtocomphep,argv[0]);
   n = strlen(_pathtocomphep)-1;
   while (n>=0 &&  _pathtocomphep[n] != f_slash) n--;
   _pathtocomphep[n]='\0';


   sprintf(pathtocomphep,"%s%c",_pathtocomphep,d_slash);
   sprintf(pathtohelp,"%shelp%c",pathtocomphep,f_slash);
   
   fscanf(stdin,"%[^\n]",procName); 
   trim(procName);


   fscanf(stdin,"%*[^\"]%*c%[^\"]%*c%*s%lf%*s%lf%*s%d%*c",xName,&xMin,&xMax,&dim);
   f=(double*)malloc(dim*sizeof(double));
   df=(double*)malloc(dim*sizeof(double));   

   fscanf(stdin,"%[^\n]",yName); trim(yName); 

   n=fscanf(stdin,"%lf +/- %lf",f,df);
   if(n==2) 
     for(i=1;i<dim;i++) fscanf(stdin,"%lf +/- %lf",f+i,df+i);
   else
   { for(i=1;i<dim;i++) fscanf(stdin,"%lf",f+i);
     free(df);
     df=NULL;
   }         
              
   sprintf(icon_name,"%sicon",pathtocomphep);
   start1(version,icon_name,"comphep.ini;../comphep.ini;[-]comphep.ini");  
   clearTypeAhead();
   plot_0(xMin,xMax,dim,f,df,procName, xName, yName);             
   finish();
}
