/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"chep_crt.h"
#include "tptcmac.h"
#include "getmem.h"
#include "syst2.h"
#include "s_files.h"
#include "physics.h"
#include "os.h"
/*#include "sets.h" */
#include "sos.h"

typedef struct allsaved
   {
        int        n_model;
        hadron       hadr1, hadr2;
        whohow       inclp, liminsp;
        int          nin, nout, n_x;
        double       sqrts, missingmass;
        shortstr     processch,
                     hadr1ch,
                     hadr2ch,
                     sqrtsch,
                     limpch;
        unsigned     sub_f, sub_sq;
        int         exitlevel;
   } allsaved;   /*  Type AllSaved  */


void restoreent(int * exitlevel)
{
 allsaved     all;
 FILE * ff;
 
   ff=fopen(scat("%stmp%csafe",pathtouser,f_slash),"rb");
   if (ff != NULL)
   {
      FREAD1(all,ff);
      fclose(ff);

      hadr1 = all.hadr1;
      hadr2 = all.hadr2;
      lvcpy( inclp, all.inclp);
      lvcpy( liminsp, all.liminsp);
      nin = all.nin;
      nout = all.nout;
      n_x = all.n_x;
      sqrts = all.sqrts;
      missingmass = all.missingmass;
      strcpy(processch,all.processch);
      strcpy(hadr1ch,all.hadr1ch);
      strcpy(hadr2ch,all.hadr2ch);
      strcpy(sqrtsch,all.sqrtsch);
      strcpy(limpch,all.limpch);
      n_model = all.n_model;
      *exitlevel = all.exitlevel;
      subproc_f = all.sub_f;
      subproc_sq = all.sub_sq;
   }
   else
   {
      strcpy(processch,"e1,E1 -> e2,E2");
      strcpy(hadr1ch,"");
      strcpy(hadr2ch,"");
      strcpy(sqrtsch,"90");
      strcpy(limpch,"");
      n_model = 1;
      *exitlevel = 0;
   }   /*  ioErr  */
}


void saveent(int  exitlevel)
{  FILE * ff;
   allsaved     all;
   all.hadr1 = hadr1;
   all.hadr2 = hadr2;
   lvcpy( all.inclp, inclp);
   lvcpy( all.liminsp, liminsp);
   all.nin = nin;
   all.nout = nout;
   all.n_x = n_x;
   all.sqrts = sqrts;
   all.missingmass = missingmass;
   strcpy(all.processch,processch);
   strcpy(all.hadr1ch,hadr1ch);
   strcpy(all.hadr2ch,hadr2ch);
   strcpy(all.sqrtsch,sqrtsch);
   strcpy(all.limpch,limpch);
   all.n_model = n_model;
   all.exitlevel = exitlevel;
   all.sub_f = subproc_f;
   all.sub_sq = subproc_sq;

   ff=fopen(scat("%stmp%csafe",pathtouser,f_slash),"wb"); 
   fwrite(&all,sizeof(all),1,ff);
   fclose(ff);
}


void  save_sos(int ercode)
{
   unsigned         nproc;
   csdiagram    cd;
   marktp mark;

   if (ercode == -2) /* User Break */
   {
      saveent(7);
      finish();
      exit(13);  /*  Restart  */
   }
 
   if (ercode == -1) /* Heap is empty */
   { mark.blk_=NULL;
     mark.pos_=0;
     release_(&mark);
   } /* Heap is empty, continue */
     
     /*  TooLargeNumber  */
     /*  TooManyIdentifiers  */
     /*  RangeCheckError  */
   if ((ercode < 0)   || (ercode == 7) ||
       (ercode == 11) || (ercode == 12))   /*  Restart  */
   {
      saveent(9);
      nproc = ftell(diagrq) - sizeof(cd);
      fseek(diagrq,nproc,SEEK_SET);
      FREAD1(cd,diagrq);
      cd.status = -2;
      fseek(diagrq,nproc,SEEK_SET);
      FWRITE1(cd,diagrq);
      finish();
      exit(13);  /*  Restart  */
   }

/*  not disk space  */
   if ((ercode == 40))
   {
      /*  freez */
      saveent(6);
      finish();
      exit(0);  /*  End of work  */
   }
   if(ercode ==14)   
   {
      saveent(1);
      messanykey(10,10," Check model !$");
      finish();
      exit(13);  
   }
}
