/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"chep_crt.h"
#include "tptcmac.h"
#include "syst2.h"
#include "s_files.h"
#include "sos.h"
#include "showgrph.h"
#include "red_out.h"
#include "r_code.h"
#include "file_scr.h"
#include "read_mdl.h"
#include "os.h"
#include "crt_util.h"
#include "physics.h"
#include "screen.h"

int    menulevel;

#define tcol Green
#define mpos 7
#define graphpos 8


static void diag_stat(int type,int * n_sub, int * n_del, int *n_calc,int * n_rest)
{
int ndel,ncalc,nrest;
long nn;
char buff[50];
FILE * tmp, **menu;

 *n_sub=0, *n_del=0, *n_calc=0, *n_rest=0;

  if(type==1) { menu=&menup; strcpy(buff,MENUP_NAME);}
  else        { menu=&menuq; strcpy(buff,MENUQ_NAME);}

  tmp=*menu;
  *menu=fopen(buff,"rb"); 
  if(*menu) 
  {
     while (rd_menu(type, *n_sub+1 ,buff, &ndel,&ncalc,&nrest,&nn)) 
     {  
        (*n_sub)++;
        *n_del +=ndel;
        *n_calc+=ncalc;  
        *n_rest+=nrest;
     }
     fclose(*menu);
  }
  *menu=tmp; 
  return; 
}


static void  readtext(char* fname)
{
   FILE * txt;
   trim(fname);
   txt=fopen(fname,"r");
   if (txt == NULL)
   {
      messanykey(10,10," File not found $");
      return;
   }
   showtext (1, 1, 80,1,"",txt);
   fclose(txt);
}


void writeModelFiles(int l)
{
  int i;
  char fName[STRSIZ];
  sprintf(fName,"%smodels%c%%s%d.mdl",pathtouser,f_slash,l);
  for(i=0;i<4;i++) writetable ( &modelTab[i],scat(fName,mdFls[i]));
}



void  editModel( int  edit)
{int  n,i,j;
 void *  pscr = NULL;
 int edited=FALSE;
 char  tabMenu[STRSIZ], tabName[80];
 char menuName[30]; 
 char tabhelp[4][10]={ "s_mdl_1", "s_mdl_2", "s_mdl_3", "s_mdl_4"};

 n = 1;
 
cont:
   do
   {
      if (edit) strcpy(menuName,"Edit  model"); 
           else strcpy(menuName,"View   model");
      strcpy(tabMenu,"\017");
      for (i=0;i<4;i++)
      { strcpy(tabName,modelTab[i].headln);
        trim(tabName);
        sbld(tabName," %s",tabName);
	for (j=strlen(tabName); j<15;j++) tabName[j]=' ';
        tabName[15]=0;
	strcat(tabMenu,tabName);
      }
      if (edit) menu1(17,15,"",tabMenu,"s_mdl_e",&pscr,&n);
          else  menu1(17,15,"",tabMenu,"s_mdl_v",&pscr,&n);  
      if (n >0 && n<=4)
	 edited =  edittable(1,1,&modelTab[n-1],1,tabhelp[n-1],!edit) || edited;
   }  while (n != 0);

   if  ( edited)
   {
      if  (mess_y_n(15,19," Save corrections ? $") )
      {
         if (loadModel(TRUE) ) writeModelFiles(n_model); else  goto cont;

      }
      else  readModelFiles(n_model);
   }
}


void         showheap(void)
{ /* goto_xy(60,24);  print("Memory= %lu",usedmemory);*/ }


void         menuhelp(void)
{
  scrcolor(Red,BGmain);
  goto_xy(23,4);print("Abstract");
  scrcolor(FGmain,BGmain);
  goto_xy(1,6);
  print("     CompHEP package is created for calculation of \n"); 
  print("  decay and high energy collision processes of     \n"); 
  print("  elementary particles in the lowest order (tree)  \n");
  print("  approximation. The main idea put into the CompHEP\n");
  print("  was to make available passing from the lagrangian\n"); 
  print("  to the final distributions effectively with the  \n");
  print("  high level of automatization.\n");
  print("     Use F2 key to get information about interface \n");   
  print("  facilities and F1 - as online help.              \n");
 
  scrcolor(Black,BGmain);
  chepbox(1,5,53,15);
  scrcolor(FGmain,BGmain);
}


void         modelinfo(void)
{
     goto_xy(5,1);
     scrcolor(Red,BGmain); print("   Model:  ");
     scrcolor(FGmain,BGmain);
     print("%s",copy(modelmenu,n_model * 22 - 20,22));
}


void         processinfo(void)
{
   goto_xy(5,3);
   scrcolor(Red,BGmain); print(" Process:  ");
   scrcolor(FGmain,BGmain);
   print("%s",processch);
}


void         diagramsinfo(void)
{  int n_sub, n_del, n_calc, n_rest;

   diag_stat(1,&n_sub,&n_del,&n_calc,&n_rest);
   if(!n_sub) return;
   goto_xy(15,5);
   scrcolor(Red,BGmain);
   print(" Feynman diagrams \n");
   scrcolor(FGmain,BGmain);
   print("      diagrams in      subprocesses  are constructed.\n");
   print("      diagrams  are deleted.");
   scrcolor(Blue,BGmain);
   goto_xy(1,6);
   print("%d",n_del+n_calc+n_rest);
   goto_xy(20,6);
   print("%d",n_sub);
   goto_xy(1,7);
   print("%u",n_del);
   while (where_y() < 7) print(" ");
   
}


void  sq_diagramsinfo(void)
{
   int n_sub, n_del, n_calc, n_rest;


   diag_stat(2,&n_sub,&n_del,&n_calc,&n_rest);
   if(!n_sub) return;

   goto_xy(15,9);
   scrcolor(Red,BGmain);
   print(" Squared diagrams \n");
   scrcolor(FGmain,BGmain);
   print("      diagrams in      subprocesses  are constructed.\n");
   print("      diagrams  are deleted.\n");
   print("      diagrams  are calculated.");
   scrcolor(Blue,BGmain);
   goto_xy(1,10);
   print("%d",n_del+n_calc+n_rest);
   goto_xy(20,10);
   print("%d",n_sub);
   goto_xy(1,11);
   print("%d",n_del);
   while (where_x() < 7) print(" ");
   goto_xy(1,12);
   print("%d",n_calc);
   goto_xy(1,13);
   
}

static void f7_key_prog(int x)
{ 
  static char delstr[5]="}D{";
  inkeyString=delstr;   
}

static void f8_key_prog(int x)
{
  static char delstr[5]="}R{";
  inkeyString=delstr;   
}


static void menu_f (int col, int row,char* label, char* f_name, char * help,
                                             void* hscr,int * kk)
{
FILE * f;
int nline,i;

char * menustr;
char ch1,ch2;

f= fopen(f_name,"r");
if (f==NULL) return;

fread(&ch1,1,1,f);
fread(&ch2,1,1,f);

fseek(f,0,SEEK_END);
nline=ftell(f)/ch2;

menustr=(char *) malloc(2+nline*ch1);
fseek(f,2,SEEK_SET);

menustr[0]=ch1;
for (i=1;i<=nline;i++) 
{ fread(menustr + 1+(i-1)*ch1,ch1,1,f); 
  fseek(f,ch2-ch1,SEEK_CUR);
}
  fclose(f);
  menustr[1+nline*ch1]=0;  
  menu1 (col, row,label,menustr, help, hscr, kk);

}


void  sqdiagrmenu(void)
{  void * pscr = NULL ;


   if (subproc_sq == 1) { nsub = 1; return;}
  
   menu_f(9,16,"NN      Subprocess                Del   Calc  Rest ",
       MENUQ_NAME,"s_sq_proc",&pscr,&nsub);
  if(nsub) put_text(&pscr);

}   /*  View squared diagrams  */


void  viewsqdiagr(void)
{   /*  View squared diagrams  */
   nsub = 1;
   do
   {
      sqdiagrmenu();
      if (nsub != 0) showgraphs(2);
      sq_diagramsinfo();
   }  while (!(nsub == 0 || subproc_sq == 1));   /*  Esc  */
   sq_diagramsinfo();
}   /*  View squared diagrams  */


void  viewfeyndiag(int del_mode)
{
 void * pscr = NULL;
 int   tp;


   tp = del_mode ? 1 : -1;
   if(del_mode){ f3_key[4]=f7_key_prog; f3_key[5]=f8_key_prog;}       
   nsub = 1;
   do
   {
      if (subproc_f == 1) nsub = 1; else
      {
         menu_f(9,11,"NN        Subprocess              Del   Rest ",
          MENUP_NAME,"s_proc",&pscr,&nsub);

      }
      if (nsub > 0) {showgraphs(tp);  if(del_mode) diagramsinfo();}         
   }  while (!(nsub == 0 || subproc_f == 1));

   if(del_mode){ f3_key[4]=NULL; f3_key[5]=NULL;} 
}



int  viewresults(int toDelete)
{searchrec  s;
 
 int   i,k,kmenu,doserror;
 void *  pscr  = NULL;
 void *  pscr2 = NULL;
 
 shortstr  newname, oldname;
 char f_name[STRSIZ];
 char  menustr[2016];

   menustr[0]=15;
   k=1;
   doserror = find_first(scat("%sresults%c*.*",pathtouser,f_slash),&s,anyfile);
   while (doserror == 0 && k<=2000)
   {  
     for (i = 1; (i <= strlen(s.name))&&(i<=15); i++) menustr[k++]=s.name[i-1];
     for (i = strlen(s.name) + 1; i <= 15; i++) menustr[k++]=' '; 
     doserror = find_next(&s);
   }
   menustr[k]=0;
   
   if (menustr[1] == 0 )
   {
      if(!toDelete) messanykey(10,15,"directory RESULTS is empty$");
      return 1;
   }
   
   if(toDelete)  messanykey( 10,10,
          "There are  files in directory Results.$"  
          "You must clear  or rename this directory$");                   
   
   kmenu = 1;   
label_1:

   menu1(10,10,"","\010"
      " View   "
      " Delete "
      " Rename ","s_res",&pscr,&kmenu);
      
   switch (kmenu)
   {
     case 0:
       return 0;         
     case 1:
      k = 1;
      do
      { 
         menu1(10,10,"",menustr,"",&pscr2,&k);
         if (k > 0) 
         {sprintf(f_name,"%sresults%c%.15s",pathtouser,f_slash,menustr+k*15-14);
          readtext(f_name);
         }                   
      }  while (k != 0);         
      break;

     case 2:
      if ( mess_y_n( 6,13," Delete files $") )
      {
        find_first(scat("%sresults%c*.*",pathtouser,f_slash),&s,archive);
        do
        { 
          unlink(scat("%sresults%c%s",pathtouser,f_slash,s.name)); 
          doserror = find_next(&s);
        }while (doserror == 0);
        put_text(&pscr);         
        return 1;
      }  
      break;

     case 3:
      strcpy(newname," ");
      while(TRUE)
      {  void * pscr3;
         get_text(1,maxRow(),maxCol(),maxRow(),&pscr3); 
         goto_xy(1,maxRow());
         print("Enter new name: ");
	 k = str_redact(newname,1,30);
	 if (k == KB_ESC)
	 {   goto_xy(1,24);
             clr_eol();
             goto label_1;
         }
	 if (k == KB_ENTER)
         {  char dir[10];
            trim(newname);
            if ( f_slash == ']') strcpy(dir,".dir"); else dir[0]=0; 
 
            sbld(newname,"%s%c%s%s",_pathtouser,f_slash,newname,dir);
            sbld(oldname,"%s%c%s%s",_pathtouser,f_slash,"results",dir);
            if(rename(oldname,newname)==0)
            {
               chepmkdir(oldname);
               put_text(&pscr);
               put_text(&pscr3);
               return 1;
            }
             else  messanykey(10,15," Can't rename the directory$");
         }
         put_text(&pscr3);   
      }
   } 
   goto label_1;
}


void f3_key_prog(int x)
{
  int i;
  for(i=0; i<8 && f3_key_prog != f3_key[i] ; i++);
  if(i<8) f3_key[i]=NULL;  /* LOCK */

    editModel(FALSE);

  if(i<8) f3_key[i]=f3_key_prog;  /* UNLOCK */

}



void f4_key_prog(int x)
{ int nsubtmp;
  int i;
  for(i=0; i<8 && f4_key_prog != f3_key[i] ; i++);
  if(i<8) f3_key[i]=NULL;  /* LOCK */
     nsubtmp = nsub;
     viewfeyndiag(FALSE);
     nsub = nsubtmp;
  if(i<8) f3_key[i]=f4_key_prog;  /* UNLOCK */
}


void f6_key_prog(int x)
{
  int i;
  for(i=0; i<8 && f6_key_prog != f3_key[i] ; i++);
  if(i<8) f3_key[i]=NULL;  
  viewresults(0);
  if(i<8) f3_key[i]=f6_key_prog;
}

void f9_key_prog(int x)
{
  if ( mess_y_n(56,maxRow()-5," Quit session?  $"))
  {
     saveent(menulevel);
     finish();
     exit(0);
  }
}



