/*
 Copyright (C) 1997, Alexander Pukhov, e-mail: pukhov@theory.npi.msu.su
*/
#include"chep_crt.h"
#include "tptcmac.h"
#include "syst2.h"
#include "os.h"
#include "physics.h"
#include "screen.h"
#include "lbl.h"
#include "constr.h"
#include "read_mdl.h"
#include "sos.h"
#include "process.h"
#include "s_files.h"
#include "squar.h"
#include "r_code.h"
#include "c_out.h"
#include "fort_out.h"
#include "red_out.h"
#include "math_out.h"
#include "form_out.h"
#include "symbolic.h"
#include "m_utils.h"


#include "interpret.h"


int main(int argc,char** argv)
{   

int      exitlevel; 
/*===================================
if (exitlevel == odd) { don't write chep_label, 
                        the same as a exitlevel--}
0 - Fisrt start
2 - Feynman diagrams menu
4 - Feynman diagrams calculation                        
6 - Squared diagrams menu
8 - Squared diagrams calculation
==========================================================*/

/* 0-Start; 1-Restart; 2-Heap Error,3-Edit Model,4-UserBreak */

  void *pscr1=NULL,*pscr2=NULL,*pscr3=NULL,*pscr4=NULL,*pscr5=NULL;
  int   k1=1,k2=1,k3=1,k4=1,k5=1;
/* menu variables */

   {   char *p=getenv("COMPHEP");
       int n;
       if(!p) { fprintf(stderr," Environment variable COMPHEP is not defined.\n");
                exit(0);
              }
       strcpy(_pathtocomphep,p);
                                         
      strcpy(_pathtouser,defaultPath);
      for ( n=1;n<argc;n++) 
      { if (strcmp(argv[n],"-blind")==0 )
        {  blind=TRUE;
           inkeyString=argv[n+1];
           n++;
        }
      }    
   }
   sprintf(pathtouser,"%s%c",_pathtouser,d_slash);
   sprintf(pathtocomphep,"%s%c",_pathtocomphep,d_slash);   
   sprintf(pathtohelp,"%shelp%c",pathtocomphep,f_slash);
   outputDir="results/";        
   start1(version,scat("%s%s",pathtocomphep,"icon"),
	"comphep.ini;../comphep.ini;[-]comphep.ini");
	
   fillModelMenu();
   
   f3_key[0]=f3_key_prog;   f3_mess[0]="Model"; 
   f3_key[1]=f4_key_prog;   f3_mess[1]="Diagrams"; 
   f3_key[3]=f6_key_prog;   f3_mess[3]="Results"; 
                            f3_mess[4]="Delete"; 
                            f3_mess[5]="Restore";
   f3_key[6]=f9_key_prog;   f3_mess[6]="Quit";    

   restoreent(&exitlevel);
   if((!exitlevel&1)&&!blind) cheplabel();
   exitlevel=2*(exitlevel/2);
   if(exitlevel>=2)
   {  readModelFiles(n_model); 
      loadModel(FALSE);
      modelinfo();
      processinfo();
      diagramsinfo();
      k1=n_model;
   }
   if(exitlevel>=6)   sq_diagramsinfo();
   switch (exitlevel)
   {
      case 2:  goto label_41;
      case 4:  goto label_41;
      case 6:  goto label_50; 
      case 8:  goto restart2;
   }
        
label_20:   /*   Menu2(ModelMenu): */
   f3_key[0]=NULL; /*models*/ 
   f3_key[1]=NULL; /*diagrams*/
   menulevel = 0;
   menuhelp();
   do
   {
      showheap();
      k1=n_model;
      menu1(56,4,"",modelmenu,"s_1",&pscr1,&k1);
      n_model=k1;
      if (n_model == 0)
      {
	if ( mess_y_n(56,4,"  Quit session  $"))   /*  Exit  */
        {  
          saveent(menulevel);
          goto exi;
        }         
      }
      else
         if (n_model > maxmodel)
         {
            clrbox(1,4,55,18);
            if (makenewmodel()) modelinfo();
            menuhelp();
         }
         else
         if (n_model > 0)
         { 
	    readModelFiles(n_model);
	    put_text(&pscr1);
	    goto label_30;
	 }
   }  while(TRUE);

label_30:   /*  Menu3:Enter Process  */


   f3_key[0]=NULL; 
   f3_key[1]=NULL; 


   menulevel = 0;
   modelinfo();
   k2 = 1;
   do
   {
      menu1(56,4,"","\026"
        " Enter Process        "
        " Edit model           "
        " Delete model         ","s_2_*",&pscr2,&k2);
      switch (k2)
      {
         case 0:  /*  'Esc'  */
           goto_xy(1,1);
           clr_eol();
           goto label_20;

	 case 2:
           editModel(TRUE);
	   break;
         case 3:  /*  Delete  */
	    if ( deletemodel(n_model) )
            {
               goto_xy(1,1);
               clr_eol();
               n_model=1;
               fillModelMenu();
               goto label_20;
            }
            else   readModelFiles(n_model);
      } /*  CASE  */
   }  while (k2 != 1);

	loadModel(FALSE);
label_31:

   f3_key[0]=NULL; 
   f3_key[1]=NULL; 

   menulevel=0;
   enter(&errorcode);   /*  Enter a process  */
   showheap();
   if (errorcode != 0)   /*  'Esc' pressed  */
   {
      menuhelp();
      goto label_30;
   }
   construct();          /*  unSquared diagrams  */
   if (errorcode != 0)
   {
      clrbox(1,19,80,24);
      goto label_31;   /*  processes are absent  */
   }
   else
   {
   
     if(!viewresults(1)) goto label_31;
      
     clr_scr(FGmain,BGmain);
     modelinfo();
     processinfo();
     diagramsinfo();
     goto label_41;	
   }
   
label_40: /*  Menu4: Squaring,...*/
   clr_scr(FGmain,BGmain);
   modelinfo();
   processinfo();
   diagramsinfo();
   showheap();
label_41: 

   f3_key[0]=f3_key_prog; 
   f3_key[1]=NULL; 

   menulevel=2;  
   k3 = 1;
   do
   {
      menu1(56,4,"","\026"
         " Squaring             "
         " View diagrams        ","s_squa_*",&pscr3,&k3);
      switch (k3)
      {
         case 0:  /*  Esc  */
            clrbox(1,2,55,11);
            menuhelp();
            goto label_30;
         case 2:  /*  unSquared process menu   */
            viewfeyndiag(TRUE);
      }   /*  CASE  */
   }  while (k3 != 1);      


/*  diagrams  */
	if (!squaring()) goto label_40;  /*  process are absent  */

   clear_tmp();

   saveent(menulevel);
   restoreent(&exitlevel);  

label_50:   /*  Menu5: View squared diagrams.....   */



   f3_key[0]=f3_key_prog; 
   f3_key[1]=f4_key_prog; 

   menulevel=6;
   clr_scr(FGmain,BGmain);
   modelinfo();
   processinfo();
   diagramsinfo();
   sq_diagramsinfo(); /*   ????????   */

   showheap();
   k4 = 1;
   while(TRUE)
   {  
   if(!continuetest())
   {   
      menu1(56,4,"","\026"
         " View squared diagrams"
         " Symbolic calculations"
         " REDUCE program       "        
         " Make n_comphep_c     "
         " Make n_comphep_f     "
         ,"s_calc_*",&pscr4,&k4);
      switch (k4)
      {  case 0:
            if (mess_y_n(50,3,"Return to previous menu?$"))goto label_40;
         break;

         case 1:
            viewsqdiagr();
            put_text(&pscr4);
            break;

         case 2:     /*  Compute all diagrams   */
restart2:
            f3_key[0]=f3_key_prog; 
            f3_key[1]=f4_key_prog; 

            menulevel=6;
            calcallproc();
            showheap();
            sq_diagramsinfo();
            put_text(&pscr4);
         break;
         case 3:
            mk_reduceprograms();
         break;
         case 4:
            saveent(menulevel);
            finish();
            return 24;
         case 5:
            saveent(menulevel);
            finish();
            return 25;
      }  /* Case */
      
   } else   
   {  
      saveent(6);
      
      menu1(56,4,"","\026"
         " View squared diagrams"
         " Write  results       "
         " Numerical interpreter"
         " C-compiler           "
         " Fortran compiler     "
         ,"s_out_*",&pscr4,&k4);
      switch (k4)
      {  case 0:
            if (mess_y_n(50,3,"Return to previous menu?$"))goto label_40;
            break;

         case 1:
            viewsqdiagr();
            put_text(&pscr4);
            break;
         case 2:
            k5 = 1;
            menu1(56,6,"","\026"
              " REDUCE code          "
              " MATHEMATICA code     "
              " FORM code            "
              " C code(for num.calc.)"
              " Fortran Real*8 code  "
              " Fortran Real*16 code " ,NULL,&pscr5,&k5);
              
            switch (k5)
            {
               case 1:
                  makeReduceOutput();
               break;
               case 2:
                  makeMathOutput();
	       break; 
	       case 3:
		  makeFormOutput();
               break;
               case 4:   /*  c_code  */
                  c_prog();
               break;
               case 5:   /*  Fortran code  */
                  fortprg(0,"");
               break;   
               case 6:
                  fortprg(1,"");   
               break;
            } /* switch(k5) */
	    put_text(&pscr5);
         break;

         case 3: 
            interpretator(); 
            break;
         case 4:
            { char command[STRSIZ];
               sprintf(command,"%s%claunch__n_comphep c &",_pathtocomphep,f_slash); 
               system(command); 
            }
            break;   
                     
         case 5:  

            { char command[STRSIZ];
              sprintf(command,"%s%claunch__n_comphep f &",_pathtocomphep,f_slash);
              system(command);
            }
                                                        
            break;                                                        
      } /*case*/
   }

   }
  
exi:
   finish();
   return 0;
}
