/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "tptcmac.h"
#include "syst2.h"
#include "pvars.h"
#include "polynom.h"
#include "tensor.h"
#include "spinor.h"
#include "parser.h"
#include "sos.h"
#include "reader0.h"

#include "reader2.h"

#ifdef STRACE
#include "test_wrt.h"
#endif
int  r_reading2 = FALSE;


pointer   rd_(char* s)
{ int     i;
  poly     p, ans;

   newmonom(&p);

   ans = plusone();
   p->next = ans;
   ans->coef.complex.re = plusone();
   ans->coef.complex.im = NULL;


   if (isdigit(s[0]))
   {  long l;
      sscanf(s,"%ld",&l);
      multtensint(&ans,l);
      p->next = ans;
      p->coef.type=numbertp;      
   }
   else
   {  
      p->coef.type = polytp;
      if (strlen(s) == 2 && isdigit(s[1]) && s[1] != 0)
      {
         i = s[1] - '0';
         switch (s[0])
         {
            case 'p':
            case 'P':
               p->coef.type = vectortp;
               ans->tail.tens[0] = -abs(momsubst[i-1]);
               if (momsubst[i-1] < 0)
                  (ans->coef.complex.re)->coef.num = - NUM_ONE;
            break;

            case 'm':
            case 'M':
               p->coef.type = indextp;
               ans->tail.tens[0] = indsubst[i-1];
               if ( s[0] == 'M') ans->tail.tens[0]--;
               if (ans->tail.tens[0] == 1)  ans->tail.tens[0] = 0;
               else ans->tail.tens[ans->tail.tens[0]-1] = 1;
         } /*  Case  */
         if (strcmp(s,"G5") == 0)
         {
            p->coef.type = spintp;
            ans->tail.spin.g5 = 1;
         }
      }

      if (p->coef.type == polytp)
      {
        if(strcmp(s,"i")==0) 
        {  ans->coef.complex.im = ans->coef.complex.re;
           ans->coef.complex.re = NULL;
        }else 
        {
           i = 1;
           while (strcmp(vardef->vars[i-1].name,s) != 0)
            if (++i > vardef->nvar) save_sos(14);
           ans->coef.complex.re->tail.power[vardef->vars[i-1].wordpos-1] =
              vardef->vars[i-1].zerodeg;
        }
      }  
   }
#ifdef STRACE
	tracePrn(" \n rd_ (%s) -> ",s);
	writeexpression(p);
#endif
   return (pointer)p;
}


pointer  uact_(char* ch,pointer mm)
{poly      p, m;
 int  np;
 int  i;

#ifdef STRACE
	tracePrn("\n uact_ (%s)\n",ch);
	writeexpression((poly)mm);
	tracePrn(" -> ");
#endif

   m = (poly)mm;
   p = m->next;
   if (strcmp(ch,"G") == 0 || strcmp(ch,"g") == 0)
   {
      while (p != NULL)
      {
         np = p->tail.tens[0];
         for (i = 0; i < spinLength; i++) p->tail.power[i] = 0;
         p->tail.spin.l = 1;
         p->tail.spin.g5 = 0;
         p->tail.spin.g[0] = np;
         p = p->next;
      }
      if (m->next->tail.spin.g[0] == 0) m->next->tail.spin.g[0] = 1;
		m->coef.type = spintp;
		if (r_reading2) m= (poly) uact_("-",m);
   }
   else
      if (strcmp(ch,"-") == 0 ) multtensint(&p,-1);

#ifdef STRACE
	writeexpression((poly)m);
#endif

   return (pointer)m;
}


pointer  bact_(char ch,pointer mm1,pointer mm2)
{
 poly      p1, p2, p3;
 int   t1, t2, t3;
 int   i;
 int   d;
 pointer mm3;

	if ( r_reading2 && (ch=='*') )
	{
		mm3=mm1;
		mm1=mm2;
		mm2=mm3;
	}

#ifdef STRACE
	tracePrn("\n bact_ (%c)\n",ch);
	writeexpression((poly)mm1);tracePrn(" |%c| ",ch);
	writeexpression((poly)mm2);tracePrn(" -> ");
#endif


   p1 = ((poly)mm1)->next;
   p2 = ((poly)mm2)->next;
   t1 = (int)(((poly)mm1)->coef.type);
   t2 = (int)(((poly)mm2)->coef.type);
   delmonom(((poly*)&mm1));
   delmonom(((poly*)&mm2));

   if ((ch == '+' || ch == '*' || ch == '.') && t1 < t2)
   {
      p3 = p1; p1 = p2; p2 = p3;
      t3 = t1; t1 = t2; t2 = t3;
   }
   t3 = -1;   /*  Error  */
   switch (ch)
   {
      case '/': printf("unexpected division\n");
                exit(1);

      case '+':
         switch (t1)
         {
             case numbertp:
             case polytp:
             case tenstp:
             case vectortp:
                sewtens(&p1,&p2,tensLength);
                p3 = p1;
                t3 = tenstp;
/* ----- */  break;

             case spintp:
                if (t2 != spintp)
                { poly pp=p2;
                  for(;pp;pp=pp->next)
                  for (i=tensLength; i < spinLength; i++) pp->tail.power[i]=0;
                }    
                sewtens(&p1,&p2,spinLength);
                p3 = p1;
                t3 = spintp;
                
/* ----- */  break;
         } /*  Case */
      break;

      case '*':
         switch (t1)
         {
             case numbertp:
             case polytp:
             case tenstp:
             case vectortp:
             case indextp:
               p3 = multtwotens(p1,p2);
               t3 = t1;
             break;

             case spintp:
  
                if (t2 != spintp)
                { poly pp=p2;
                  for(;pp;pp=pp->next)
                  for (i=tensLength; i < spinLength; i++) pp->tail.power[i]=0;
                }    
                p3 = multtwospin(p1,p2,FALSE);
                deltensor(&p1);
                deltensor(&p2);
                t3 = spintp;
             break;
          } /* Case */
      break;


      case '^':
         d = (p2->coef.complex.re->coef.num);
         deltensor(&p2);
         p3 = copytens(p1,tensLength);
         
         for (i = 1; i < d; i++)
         {
           p2 = copytens(p1,tensLength);
           p3 = multtwotens(p3,p2);
         }
         deltensor(&p1);
         t3 = polytp;
         
      break;

      case '.':
         p3 = multtwotens(p1,p2);         
         if (t1 == vectortp && t2 == vectortp) t3 = polytp; else t3 = tenstp;
   } /* Case */

   newmonom(&p1);
   p1->coef.type = t3;
   p1->next = p3;

#ifdef STRACE
	writeexpression((poly)p1);
#endif


   return (pointer)p1;
}
