/*
 Copyright (C) 1997, Alexander Pukhov, e-mail pukhov@theory.npi.msu.su
*/
#include"chep_crt.h"
#include "syst2.h"
#include "physics.h"
#include "s_files.h"
#include "procvar.h"
#include "os.h"
#include "out_serv.h"
#include "saveres.h"

#include "red_out.h"


static void writeprocessname(int * prtclNum)
{
   int i;
    
   writeF("inParticles:={"); 
   for (i = 1; i <= nin; i++)   
     if (i == nin) writeF("\"%s\"}$\n",prtclbase[prtclNum[i]-1].name);          
              else  writeF("\"%s\",",prtclbase[prtclNum[i]-1].name);
      
   writeF("outParticles:={");
   for (i = nin + 1; i <= nin + nout; i++)
     if (i == nin + nout) writeF("\"%s\"}$\n",prtclbase[prtclNum[i]-1].name);
                    else  writeF("\"%s\",",prtclbase[prtclNum[i]-1].name);                        
}

static void  writeparameters(int nsub)
{

 int        k;
 char        ch;
 char        s[STRSIZ];

   writeF("%%\n");
   ch = ' ';
   writeF("parameters:={");

   for(k=1;k<=nmodelvar;k++)
   {
      if (vararr[k].used && !modelvars[k].func)
      { 
         writeF("%c%s=>%E",ch,vararr[k].alias,vararr[k].tmpvalue);
         ch = ','; 
      }
   }
   writeF("}$\n");

   writeF("%%\n");
   ch = ' ';
   writeF("substitutions:={");
   for(k=nmodelvar;k;k--)
   {
      if (vararr[k].used && modelvars[k].func)
      {  sscanf(modelvars[k].func,"%[^|]",s);
         trim(s);
         writeF("%c%s=>%s",ch,vararr[k].alias,s);
         ch=',';
       }
   }
   writeF("}$\n");
}

static void  emitexpression(catrec* cr)
{
   int  i;

   seekArchiv(cr->factpos);
   readvardef();
   writeF("totFactor:=(");
   rewritepolynom();
   writeF(")/(");
   rewritepolynom();
   writeF(")$");
   writeF("\n");
   clearvardef();
   seekArchiv(cr->rnumpos);
   readvardef();
   writeF("numerator:="); rewritepolynom();writeF("$\n");
   clearvardef(); 

   seekArchiv(cr->denompos);
   readDenominators();

   writeF("denominator:=");
   if(denrno)    
     for (i = 0; i < denrno; i++)
     {  char momStr[20]; 
        momentToString(denom[i].momStr,momStr);   
      
        if(i) writeF("*");
        writeF("propDen(%s,%s,%s)",momStr, vararr[denom[i].mass].alias,
        vararr[denom[i].width].alias);
        if(denom[i].power!=1) writeF("^%d",denom[i].power);
     }
   else writeF("1");
   writeF("$\n");
}


static void startReduce(int nsub,int* prtclNum,int ncalc)
{  
   char f_name[STRSIZ];   

   outputLanguage='R';
   initvararray(nsub,outputLanguage);
   sprintf(f_name,"%sresults%csymb%d.red",pathtouser,f_slash,nsub);
   outFileOpen(f_name);
   writeLabel('%');
   writeprocessname(prtclNum);
   writeparameters(nsub);
   writeF("\n\n");
   writeF("vector p1,p2,p3,p4,p5,p6$\n");
   emitconvlow(prtclNum);

   writeF("\nvector !=p_,!=q_$\n");
   writeF("operator propDen$\n");
   writeF("for all p_,q_,m,w let propDen(0*p_+q_,m,w)=propDen(q_,m,w)$\n");
   writeF("for all p_,m,w such that ordp(p_,-p_) let propDen(p_,m,w)=propDen(-p_,m,w);$\n\n");
   writeF("initSum();\n");
}

static void diagramReduce( vcsect * vcs,  catrec * cr )
{
   writeF("\n");
   writeF("DiagrNumber:=\"%d_%d\"$\n",cr->nsub_,cr->ndiagr_);
   writeF("\n");
   if (vcs)  DiagramToOutFile(vcs,0,'%');
   emitexpression(cr);
   writeF("\n\n");
   writeF("addToSum()$\n");
}

static void endReduce(int * prtclNum)
{ 
  writeF("finishSum();\n");
  writeF("End$\n");
  outFileClose();
}

void makeReduceOutput(void)
{  makeOutput(startReduce,diagramReduce,endReduce);}

