/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "tptcmac.h"
#include "syst.h"
#include "syst2.h"
#include "physics.h"
#include "procvar.h"
#include "procvar.h"
#include "reader5.h"

pointer      bact5(char ch,pointer mm1,pointer mm2)
{
	char       *m1, *m2, *ans, *ss;
	char   r_n,  p_m;
	int r1,r2;

   m1 = (char *) mm1;
   m2 = (char *) mm2;

	if (ch=='+') p_m='P'; else p_m='M';
	r1=(m1[1]=='R'); r2=(m2[1]=='R');

	if ( r1 || r2 || ch=='/') r_n='R'; else r_n='N';

	if (m1[0] == 'M' || ch =='+')               lShift(m1,3); else { lShift(m1,2);m1[0]='(';strcat(m1,")"); }
	if ((m2[0] == 'M' || ch =='+')&& ch != '/') lShift(m2,3); else { lShift(m2,2);m2[0]='(';strcat(m2,")"); }

	ans= m_alloc(strlen(m1)+strlen(m2)+30);

   switch (ch)
   {
      case '+': 
                if (m1[0] == '-')  sprintf(ans,"%c%c|%s%s",p_m,r_n,m2,m1);
			  else  if (m2[0] == '-')	sprintf(ans,"%c%c|%s%s",p_m,r_n,m1,m2);
				  else         sprintf(ans,"%c%c|%s+%s",p_m,r_n,m1,m2);
      break;

      case '*':
			if (m2[0] != '-')	sprintf(ans,"%c%c|%s*%s",p_m,r_n,m1,m2);
			  else
			if (m1[0] != '-')	sprintf(ans,"%c%c|%s*%s",p_m,r_n,m2,m1);
			  else   			sprintf(ans,"%c%c|%s*%s",p_m,r_n,m1+1,m2+1);
      break;

		case '/':
		        
			if ( !r1)
			{	ss=m1;
				m1=m_alloc(strlen(m1)+11);
				sprintf(m1, "(double)(%s)",ss);
				free(ss);
			}
			if ( !r2)
			{	ss=m2;
				m2=m_alloc(strlen(m2)+11);
				sprintf(m2, "(double)(%s)",ss);
				free(ss);
			}
			if (m2[0] != '-')   sprintf(ans,"%c%c|%s/%s",p_m,r_n,m1,m2);
			else
			{ if (m1[0] == '-') sprintf(ans,"%c%c|%s/%s",p_m,r_n,m1+1,m2+1);
							else    sprintf(ans,"%c%c|-%s/%s",p_m,r_n,m1,m2+1);
			}
      break;

      case '^':
			if (m1[0] == '-') { lShift(m1,-1);m1[0]='(';strcat(m1,")");}
			if (m2[0] == '-') { lShift(m2,-1);m2[0]='(';strcat(m2,")");}
                        
                              if(r1&&r2)   sprintf(ans,"%c%c|pow_dd(%s,%s)",p_m,r_n,m1,m2);
                        else  if(r1&&!r2)  sprintf(ans,"%c%c|pow_dl(%s,%s)",p_m,r_n,m1,m2);
                        else  if(!r1&&r2)  sprintf(ans,"%c%c|pow_dl(%s,%s)",p_m,r_n,m2,m1);
                        else               sprintf(ans,"%c%c|pow_ll(%s,%s)",p_m,r_n,m1,m2);
                       
   }   /* Case */
	free(m1);
	free(m2);
	return (pointer) ans;
}


pointer uact5(char* ch,pointer mm)
{

  char  *m, *ans;

  m = (char *) mm;
  ans=m_alloc(strlen(m)+30);

  if (strcmp(ch,"-") == 0)
  {
		if (m[0] == 'M')
		{	if (m[3] == '-')  sprintf(ans,"M%c|%s",m[1],m+4);
			else              sprintf(ans,"M%c|-%s",m[1],m+3);
		}
		else	sprintf(ans,"M%c|-(%s)",m[1],m+3);
	}

   if (strcmp(ch,"sqrt") == 0)
   {
/*	     
      if (m[1] == 'N') sprintf(ans,"MR|sqrt_e((double)(%s),&err)",m+3);
        else           sprintf(ans,"MR|sqrt_e(%s,&err)",m+3);
*/

      if (m[1] == 'N') sprintf(ans,"MR|sqrt((double)(%s))",m+3);
        else           sprintf(ans,"MR|sqrt(%s)",m+3);

   }
	free(mm);
	return (pointer) ans;
}

pointer  rd5(char* s)
{  char      *p;
   int       l;

   p = m_alloc(30);
   if ('0' < s[0] && s[0] <= '9') sprintf(p,"MN|%s",s);
   else
   {

      for(l=1;l<=nmodelvar;l++)
      {
         if (strcmp(s,modelvars[l].varname) == 0)
         {
            sprintf(p,"MR|%s",vararr[l].alias);
            return (pointer) p;
         }
      }
   }
   return (pointer) p;
}
