/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "syst.h"
#include "syst2.h"
#include "physics.h"
#include "parser.h"
#include "pvars.h"
#include "s_files.h"
#include "os.h"
#include "out_serv.h"
#include "procvar.h"
#include "saveres.h"
int nProcessVar;

singlevardescription *vararr = NULL;

 
static pointer PP=(pointer)"PP";

static pointer  rd_4(char* s)
{int l;
 
   if (!isdigit(*s))
   {
      for(l=0;l<=nmodelvar;l++)
      {
         if (strcmp(modelvars[l].varname,s) == 0)
         { vararr[l].used=TRUE; return PP;}
      }
    }   
   return PP;
}


static pointer uact_4(char* ch,pointer mm) { return mm; }

static pointer bact_4(char ch,pointer mm1,pointer mm2) {  return mm1; }

void  initvararray(int nsub, char key)
{   int i,j,k,kk,l; 
    catrec    cr;

    polyvars  allVars={0,NULL}; 
    int nvar,nfunc;        
    
   nProcessVar = nmodelvar + 2 +((MAXINOUT*(MAXINOUT-1)/2)); 
   if (vararr) free(vararr); 
   vararr = (singlevardescription*)m_alloc(nProcessVar 
                                            * sizeof(singlevardescription)); 

   sprintf(vararr[0].alias,"0",k); 
   vararr[0].tmpvalue=0;
   vararr[0].used = FALSE;

   for(k=1; k<nProcessVar;k++)
   {  sprintf(vararr[k].alias,"#%d",k); 
      vararr[k].tmpvalue=0;
      vararr[k].used = FALSE;
   }   
   vardef=&allVars;
   fseek(catalog,0,SEEK_SET);
   while (FREAD1(cr,catalog))
   {  
      if(!nsub || cr.nsub_ == nsub)
      {
         seekArchiv(cr.factpos);
         readvardef();
         for(l=0;l<vardef->nvar;l++) vararr[vardef->vars[l].num].used=TRUE;
         clearvardef();
         seekArchiv(cr.rnumpos);
         readvardef();
         for(l=0;l<vardef->nvar;l++) vararr[vardef->vars[l].num].used=TRUE;
         clearvardef();
         seekArchiv(cr.denompos);
         readDenominators();
         for(l=0;l< denrno;l++) 
         { if( denom[l].mass)   vararr[denom[l].mass].used=TRUE;
           if( denom[l].width)  vararr[denom[l].width].used=TRUE;
         }
         clearvardef();
      }
   }
   for (k = nmodelvar ; k >=0; k--) 
   if( vararr[k].used && modelvars[k].func)
   {   
      readExpression(modelvars[k].func,bact_4,uact_4, rd_4); 
   } 
   kk=0;
   for (i = 2; i <= nin+nout; i++)
   for (j = 1; j <= i - 1; j++)
   { k=scalarProductPos(i,j); 
     switch(key)
     { case 'R':
       case 'F': sprintf( vararr[k].alias, "p%d.p%d", j, i);    break;
       case 'M': sprintf( vararr[k].alias, "SC[p%d,p%d]", j, i);break;
       case 'c': sprintf( vararr[k].alias, "DP[%d]",kk); break;
       case 'f': { char c=kk+1;
                    if(c<10) sprintf( vararr[k].alias, "P%c",'0'+c);
                    else     sprintf( vararr[k].alias, "P%c",'A'+c-10);
                 } break;
     } 
      vararr[k].used = TRUE;
      kk++; 
   }
   nvar=0;
   for(k=0;k<=nmodelvar;k++) 
   if (vararr[k].used && !modelvars[k].func)
   {  vararr[k].tmpvalue = modelvars[k].varvalue;
   
      switch(key)
      {
          case 'R':
          case 'F':
          case 'M':  strcpy( vararr[k].alias, modelvars[k].varname);break;
          case 'c':  sprintf(vararr[k].alias,"va[%d]",++nvar); break;
          case 'f':  sprintf(vararr[k].alias,"A(%d)",++nvar); break;
      }
   }
   nfunc=0;
   for(k=0;k<=nmodelvar;k++) 
   if (vararr[k].used && modelvars[k].func)
   {  vararr[k].tmpvalue = modelvars[k].varvalue;
      switch(key)
      {
          case 'R':
          case 'F':
          case 'M':  strcpy( vararr[k].alias, modelvars[k].varname);break;
          case 'c':  sprintf(vararr[k].alias,"va[%d]",++nfunc+nvar); break;
          case 'f':  sprintf(vararr[k].alias,"A(%d)", ++nfunc+nvar); break;
      }
   }
} 
