/*
 Copyright (C) 1997, Sergey Shichanin, shichan@th.ihep.su
*/
#include "tptcmac.h"
#include "syst2.h"
#include "crt.h"
#include "physics.h"
#include "s_files.h"
#include "syst2.h"
#include "getmem.h"
#include "procvar.h"
#include "out_serv.h"
#include "pvars.h"
#include "diaprins.h"
#include "optimise.h"
#include "l_string.h"
#include "parser.h"
#include "reader5_f.h"
#include "os.h"
#include "saveres.h"
#include "denominators.h"
#include "fort_out.h"

typedef char s6[7];

#define SIX "      "

/*************************************************
 *     CompHEP (R) FORTRAN code production       *
 *          (C) S.Shichanin Febr 08 1991         *
 *                          June 17 1991         *
 *         Mass identifiers and values           *
 *************************************************/


static void doub_str(char * s,  double  z )
{
     sprintf(s,"%15.6E",z);
      strchr(s,'E')[0]='D';      

/*	char buff[40],power[10];
	char * cpower,* cbuff  ;
	sprintf(buff,"%14.6E",z);
	cpower=strchr(buff,'E')-6;
	cpower[0]='E';
	cpower[1]=cpower[7];
	cpower[2]=0;
	cpower=cpower+8;
	strcpy(power,cpower);
	cpower=power;
	while ((cpower[0]=='0')&&(strlen(cpower)>2) ) cpower=cpower+1;
	cbuff=buff;
	while (cbuff[0]==' ') cbuff=cbuff+1;

	if (cbuff[0]=='-'||cbuff[0]=='+') sprintf(s, "%s%s",cbuff,cpower);
				    else  sprintf(s," %s%s",cbuff,cpower);
*/
}




#define procinfptr struct procinfrec *
typedef struct procinfrec
   {
      procinfptr     next;
      unsigned       tot;
      unsigned       firstdiagpos;
      prtclsarray    p_name;
      int            p_masspos[MAXINOUT];
   }  procinfrec;
#undef procinfptr
typedef struct procinfrec *procinfptr;


static char * ext;

static procinfptr   inf, inftmp;  /*  information about subProcess  */


       /*  statictics  */
static unsigned         ndiagrtot, diagrcount;
static int      nvars, nfunc;

static marktp      heapbeg;/*  for RELEASE  */

static int      nden_w, nden_0, nsub1; /* from writesubprocess */


static void clearstatistic(void)
{int  i;
  for (i = 17; i < 24; i++) { goto_xy(1,i); clr_eol();}
}

static void init_stat(void)
{
   goto_xy(1,17);
   scrcolor(Yellow,Blue);
   print(" FORTRAN Source Codes \n");
   scrcolor(Red,BGmain);
   print(" Process..........\n");
   print(" Total diagrams...\n");
   print(" Processed........\n");
   print(" Current..........\n");
   scrcolor(Yellow,Blue);
   print(" Press Esc to stop    ");
   scrcolor(Black,BGmain);
   goto_xy(20,18); print("%s",processch);
   goto_xy(20,19); print("%4u",ndiagrtot);
   goto_xy(20,20); print("   0");
   goto_xy(20,21); print("   1");
}


static void writestatistic(void)
{
   scrcolor(Black,BGmain);
   goto_xy(20,19); print("%4u",ndiagrtot);
   goto_xy(20,20);
   print("%2u (%%)",(((diagrcount - 1) * 100) / ndiagrtot));
   goto_xy(20,21); print("%4u",diagrcount);
}


static void writpict(unsigned ndiagr)
{vcsect vcs;
   csdiagram  csdiagr;
   fseek(diagrq,ndiagr*sizeof(csdiagr),SEEK_SET);
   FREAD1(csdiagr,diagrq);
   transfdiagr(&csdiagr,&vcs);   
   writeTextDiagram(&vcs,1,'*',outFile);
}


static void labl(void)
{
  writeF("*******************************\n");
  writeF("*    %s*\n",version);
  writeF("*******************************\n");
}

  /* =========== Preliminary  calculations ================ */

static void calc_nvars_nfunc(void)
{  int   k;

   nvars = 0;
   nfunc = 0;

   for(k=1;k<=nmodelvar;k++)
   {  
      if (vararr[k].used)
      {if( modelvars[k].func) nfunc++; else  nvars++;}
   }   
   
}   /* Calc_Nvars_NFunc; */   




static void prepareprocinform(void)
{int ndel, ncalc, nrest;
 long recpos;
 char        txt[STRSIZ];
 int     i, k;
 csdiagram   csd;
 s6          mass;
 int        nn;
 int nsubs;

   inf = NULL;
   menuq=fopen(MENUQ_NAME,"rb");
   for (nsubs=1;nsubs<=subproc_sq;nsubs++) 
   {
      inftmp = inf;
      inf = (procinfptr)getmem_((unsigned)sizeof(procinfrec));
      inf->next = inftmp;
      rd_menu(2,nsubs,txt,&ndel,&ncalc,&nrest,&recpos);
      inf->firstdiagpos = recpos;
      getprtcls(txt,inf->p_name);
      for (i = 0; i < nin + nout; i++)
      {
         locateinbase(inf->p_name[i],&nn);
         strcpy(mass,prtclbase[nn-1].massidnt);
         if(strcmp(mass,"0")) for(k=1;strcmp(modelvars[k].varname,mass);k++);
         else k=0;
         inf->p_masspos[i]=k;
      }
      for (i = nin + nout; i < MAXINOUT; i++)
      {
         strcpy(inf->p_name[i],"***");
         inf->p_masspos[i] = 0;
      }
      fseek(diagrq,recpos*sizeof(csdiagram),SEEK_SET);
      inf->tot = 0;
      for (i = 1; i <= ndel + ncalc + nrest; i++)
      {
         FREAD1(csd,diagrq);
         if (csd.status == 1) ++(inf->tot);
      }
   }
   nsubs--;
   fclose(menuq);
   revers((pointer*)&inf);
}

/* ==========   assistent procedures =============== */

static void return_end(void)
{
   writeF(SIX "RETURN\n");
   writeF(SIX "END\n");
   writeF("\n");
}

static void implicitdeclaration(void)
{ 
   writeF(SIX "IMPLICIT ");
   if (quadra) writeF("REAL*16");
   else        writeF("DOUBLE PRECISION ");
   writeF("(A-H,O-Z)\n");
}


  /* =========== Common blocks Emit =========== */



static void common_scalar(void)
{
  int i;
	writeF(SIX "COMMON/SCLR%s/P1,P2,P3",ext);
	for(i=4;i<=((MAXINOUT*(MAXINOUT-1)/2));i++)
	{  if (i==18) writeF("\n     .");
		writeF(",P");
		if (i<10) writeF("%d",i);
		else      writeF("%c",'A'-10+i);
	}
	writeF("\n");
}



static void common_scalararray(void)
{
  writeF(SIX "COMMON/SCLR%s/PP(%d)\n",ext,((MAXINOUT*(MAXINOUT-1)/2)));
}

static void common_sqs(void)
{
   if (nin > 1)
      writeF(SIX "COMMON/SQS%s/SQRTS\n",ext);
}

static void common_vars(void)
{
   if (nvars + nfunc > 0) 
      writeF(SIX "COMMON/VARS%s/A(%d)\n",ext,nvars + nfunc); 
} 

static void common_log(void)
{
  writeF(SIX "COMMON/LOGG%s/L(%u)\n",ext,subproc_sq);}

  /* ======= Information functions =========== */

static void geninf(char* name,int value)
{
   writeF(SIX "FUNCTION %s%s()\n",name,ext);
   writeF(SIX "   %s%s=%d\n",name,ext,value);
   return_end(); 
} 

static void make_indx(void)
{ 
   writeF(SIX "FUNCTION INDX%s(K,L)\n",ext);
   writeF(SIX "I=MIN(K,L)\n");
   writeF(SIX "J=MAX(K,L)\n");
   writeF(SIX "INDX%s=I+(J-1)*(J-2)/2\n",ext);
   return_end();
}

static void scanvars(int mode)
{
 int num;
 int     first;
 shortstr    valstr;
 int k;

   first = TRUE;
   switch(mode)
   {
      case 2: 
        first = FALSE;
        num=0;
      break;

      case 3:   writeF(SIX "DATA NAMES/");
      break;
   }   /* case */

   for(k=1;k<=nmodelvar;k++)
   {  varlist modl=modelvars+k;
      if(vararr[k].used && !modl->func)
      
      {
         switch(mode)
         {
	    case 2:
	    {  char buff[20];
	       doub_str(buff,modl->varvalue);
	       num++;
               writeF(SIX "A(%d)=%s\n",num,buff);
	    }
            break;

            case 3:   sprintf(valstr,"\'%s\'",modl->varname);
            break;

         }   /* CASE */
         if (mode !=2 )
         {
            if (first) first = FALSE; else writeF(",");
            writeF("%s",valstr);
         }
      }
   }

   if(mode==3)
   {
     writeF("/\n");
     return;
   }
      
   for(k=1;k<=nmodelvar;k++)
   {  varlist modl=modelvars+k;
      if(vararr[k].used && modl->func)
      {
         switch(mode)
         {
	    case 2:
	    {  char buff[20];
	       doub_str(buff,modl->varvalue);
	       num++;
               writeF(SIX "A(%d)=%s\n",num,buff);
	    }
            break;

         }   /* CASE */
      }
   }
      
}


static void  writesubroutineinit(void)
{
 varlist      p;
 int          l;
 char        * s, *ss;
 int          len,xx;
 char         c;

   writeF(SIX "SUBROUTINE INIT%s\n",ext);
   implicitdeclaration();
   common_log();

   writeF(SIX "LOGICAL RECALC \n");

   if (nvars != 0)
   {
      writeF(SIX "DIMENSION  AMEM(%d)\n",nvars);
      common_vars();
   }


   writeF(SIX "SAVE\n");

   writeF("%sDATA RECALC/.TRUE./,P1MEM/0.D0/\n",SIX);
   if (nvars > 0 )
   {
      writeF("%sDO 1 I=1,%d\n",SIX,nvars);
      writeF("%s   IF (A(I).NE.AMEM(I)) THEN\n",SIX);
      writeF("%s      RECALC=.TRUE.\n",SIX);
      writeF("%s      AMEM(I)=A(I)\n",SIX);
      writeF("%s   ENDIF\n",SIX);
      writeF("1     CONTINUE\n");
   }

   writeF("%sIF (RECALC) THEN\n",SIX);
   writeF("%s   DO 2 I=1,%u\n",SIX,subproc_sq);
   writeF("2        L(I)=0\n");
   

   for(l=1;l<=nmodelvar;l++)
   {  p=modelvars+l;
      if (vararr[l].used && modelvars[l].func)
      {
         ss=(char *)readExpression(p->func,bact5_f,uact5_f,rd5_f);
         s=ss+3;

         writeF("%s   %s=",SIX,vararr[l].alias);
         len=strlen(s);

         xx=65 - ( 4+strlen(vararr[l].alias) );
         if(len>xx) { c=s[xx];s[xx]=0;}
         writeF("%s\n",s);
         if (len>xx) {s[xx]=c; s+=xx;}
         len -= xx;

         while (len>0)
         {
            if (len >65){c=s[65]; s[65]=0; }
            writeF("     .%s\n",s);
            if (len >65){s[65]=c; s+=65;}
            len -= 65;
         }
      free(ss);
      }
   }
   writeF("%sRECALC=.FALSE.\n",SIX);
   writeF("%sENDIF\n",SIX);
   return_end();
}

static void common_width(void)  
{
   writeF("%sLOGICAL GWIDTH,RWIDTH\n",SIX);
   writeF("%sCOMMON/WDTH%s/ GWIDTH,RWIDTH\n",SIX,ext);
}
static void  make_vini(void)
{
   writeF("%sSUBROUTINE VINI%s\n",SIX,ext);
	implicitdeclaration();
	writeF("%sDOUBLE PRECISION SQRTS\n",SIX);
        common_vars();
	common_sqs();
	common_log();
        common_width();
	writeF("%sSAVE\n",SIX);
	writeF("%sGWIDTH=.FALSE.\n",SIX);
        writeF("%sRWIDTH=.FALSE.\n",SIX);
	if (nin > 1)
		{ char buff[40];
		  doub_str(buff,sqrts);
		  writeF("%sSQRTS=%s\n",SIX,buff);
		}
	if (nvars + nfunc > 0) scanvars(2);
    return_end();
/* 
   writeF("%sRETURN\n",SIX);
   writeF("%sEND\n",SIX);
   writeF("\n");
*/
}

static void make_cpth(void)
{
   writeF("%sSUBROUTINE CPTH%s(PATH,D_SLASH,F_SLASH)\n",    
               SIX,ext);
   writeF("%sCHARACTER*60 PATH\n",SIX);
   writeF("%sCHARACTER*1 D_SLASH,F_SLASH\n",SIX);
   
   writeF("%sPATH=\'%s\'\n",SIX,_pathtocomphep);
   writeF("%sD_SLASH=\'%c\'\n",SIX,d_slash);
   writeF("%sF_SLASH=\'%c\'\n",SIX,f_slash);
   return_end();
}

static void  common_den(void)
{
   if (nden_0 + nden_w == 0) return;
   writeF("%sCOMMON /U%d%s/ ", SIX,nsub1,ext);
   if (nden_w != 0)
      writeF("Q0(%d),",nden_w);
   writeF("Q1(%d),Q2(%d)\n",nden_0 + nden_w,nden_0 + nden_w);
}

static void  onediagram(deninforec * dendescript)
{catrec      cr;
 int         i, k;
 marktp      bh;
 varptr      totnum, totdenum, rnum;
 char        istr[10];
 int     addpr;
 int numm;
 int linepos;
 int nConst,deg1;

   mark_(&bh);
   tmpNameMax=0;
   initfortwriting('f');
   initdegnames();

   fseek(catalog,dendescript->cr_pos,SEEK_SET);
   FREAD1(cr,catalog);
   ++(diagrcount);

   fseek(archiv,cr.factpos,SEEK_SET);
   readvardef();
   readpolynom(&totnum);
   readpolynom(&totdenum);
   clearvardef();
   fseek(archiv,cr.rnumpos,SEEK_SET);
   readvardef();
   readpolynom(&rnum);
   clearvardef();
   outFileOpen(scat("%sresults%cc%d.f",pathtouser,f_slash,diagrcount));
   
   labl();

   writeF("%sSUBROUTINE CC%d(C)\n",SIX,diagrcount);
   implicitdeclaration();
   common_vars();
   common_scalar();
   linepos=ftell(outFile);
   writeF("%72s\n","");
   writeF("%sSAVE\n",SIX);
   nConst=write_const();
   deg1= cleardegnames();
   return_end(); 

   fseek(outFile,linepos,SEEK_SET);
   fprintf(outFile,"%sDIMENSION C(%d)" ,SIX,MAX(1,nConst));
    outFileClose();

   outFileOpen(scat("%sresults%cf%d.f",pathtouser,f_slash,diagrcount));
   initdegnames(); 
   tmpNameMax=0;
   labl();
   
   sprintf(istr,"F%d%s",diagrcount,ext);
   writeF("%sFUNCTION %s()\n",SIX,istr);
   writpict(cr.ndiagr_ + inftmp->firstdiagpos - 1);
   implicitdeclaration();
   common_log();
   common_vars();
   common_scalar();
   common_den();
   linepos=ftell(outFile);
   writeF("%72s\n","");
   writeF("%sSAVE\n",SIX);

            
   writeF("%sIF(L(%d).EQ.0) CALL CC%d%s(C)\n",SIX,
                         cr.nsub_,diagrcount,ext);

   fortwriter("TOTNUM",totnum);
   fortwriter("TOTDEN",totdenum);
   fortwriter("RNUM",rnum);


   writeF("%s%s=RNUM*(TOTNUM/TOTDEN)",SIX,istr);

   for (i = 1; i <= dendescript->tot_den; i++)
   {  numm =
         dendescript->denarr[i-1].width ?
            dendescript->denarr[i-1].order_num:
            dendescript->denarr[i-1].order_num + nden_w ;
           
      if (dendescript->denarr[i-1].power == 1)
         writeF("*Q1(%d)",numm);
      else
         writeF("*Q2(%d)",numm);
   }
   
   for (k = 1; k <= nden_w; k++)
   {
      addpr = TRUE;
      for (i = 1; i <= dendescript->tot_den; i++)
      if ( dendescript->denarr[i-1].width &&
      k == dendescript->denarr[i-1].order_num)  addpr = FALSE;
      if (addpr)  writeF("*Q0(%d)",k);
   }
   writeF("\n");

   return_end();

   fseek(outFile,linepos,SEEK_SET);
   fprintf(outFile,"%sDIMENSION C(%d)" ,SIX,MAX(1,nConst));
   deg1=cleardegnames(); 
                                            
   outFileClose();
   release_(&bh);
}  /* OneDiagram */

static void  writesubprocess(int nsub,int* breaker)
{ 
  denlist    den_,den_tmp;
  int i;
  deninforec  dendescript;
    
  FILE * fd;                /* file of (deninforec)  */
  char fd_name[STRSIZ];
  marktp free_mem;

   nsub1 = nsub;

 
   sprintf(fd_name,"%stmp%cden.inf",pathtouser,f_slash);

   fd=fopen(fd_name,"wb"); 
   
   outFileOpen(scat("%sresults%cd%d.f",pathtouser,f_slash,nsub));
   writeF("%sSUBROUTINE D%d%s\n", SIX, nsub, ext);
   implicitdeclaration();
   common_log();
   common_vars();
   common_width();
   common_scalar();

 mark_(&free_mem);
   denominatorStatistic(nsub, &nden_w, &nden_0, &den_, fd);

   common_den();
   if(nden_w!=0)writeF(
       "%sDIMENSION DMASS(%d),DWIDTH(%d)\n",SIX,nden_w,nden_w);
   writeF("%sSAVE\n",SIX);

   while (den_ != NULL)
   {  int j1,j2,k1,k2,ch; 
       i=den_->order_num;
       if (den_->width)
       {    
          writeF("%sDMASS(%d)=%s\n",SIX,i,vararr[den_->mass].alias);
          writeF("%sDWIDTH(%d)=%s\n",SIX,i,vararr[den_->width].alias);
       }else i+=nden_w;
       writeF("%sQ1(%d)=",SIX,i);
       
       j1=0; while( den_->momStr[j1])
       { 
          j2=inftmp->p_masspos[den_->momStr[j1]-1];
          if(j2)
          { 
             if(den_->mass==j2) {j2=0; den_->mass=0;}
             if(j2) writeF("-%s**2",vararr[j2].alias);
          } 
          j1++;                          

       }     

       if(den_->mass!=0)
       writeF("+%s**2",vararr[den_->mass].alias);
     
       writeF("-2*(");
       j1=1;
       while(den_->momStr[j1]) 
       { for(j2=0;j2<j1;j2++) 
         {  k1=den_->momStr[j1];
            k2=den_->momStr[j2];
            if(k1<k2) { ch=k1;k1=k2;k2=ch;}
            if(k1>nin &&k2<=nin) ch='-';else ch='+';
            k2+=((k1-1)*(k1-2))/2;
            if(k2<10) writeF("%cP%c",ch,'0'+k2);
             else     writeF("%cP%c",ch,'A'+k2-10);
         }
         j1++;
       }
       writeF(")\n" );
       den_tmp=den_;
       den_ = den_->next;
   }
 release_(&free_mem);
   
   if (nden_w > 0)
   {
      writeF( "%sDO 2 I=1,%d\n", SIX, nden_w);
      writeF( "%sIF (RWIDTH) THEN\n",SIX);
      writeF(
 "%s  Q2(I)=1/(Q1(I)**2+((DMASS(I)-Q1(I)/DMASS(I))*DWIDTH(I))**2)\n",SIX);
      writeF( "%sELSE\n",SIX);
      writeF( "%s  Q2(I)=1/(Q1(I)**2+(DMASS(I)*DWIDTH(I))**2)\n", SIX);
      writeF( "%sENDIF\n",SIX);
      writeF( "%sIF (GWIDTH) THEN\n",SIX);
      writeF( "%s  Q0(I)=Q2(I)*Q1(I)**2\n", SIX); 
      writeF( "%sELSE\n",SIX);
      writeF( "%s  Q0(I)=1 \n", SIX);
      writeF( "%sENDIF\n",SIX);
      writeF( "%s  Q1(I)=Q2(I)*Q1(I)\n", SIX);
      writeF( "2     CONTINUE\n");
   }

   if (nden_0 > 0)
   {
      writeF( "%sDO 3 I=%d,%d\n", SIX, 1+nden_w, nden_w + nden_0);
      writeF( "%s  Q1(I)=1/Q1(I)\n", SIX);
      writeF( "%s  Q2(I)=Q1(I)**2\n", SIX);
      writeF( "3     CONTINUE\n");
   }

  /* ===================== */
   return_end();
   outFileClose();
   fclose(fd);
   fd=fopen(fd_name,"rb");
   *breaker = FALSE;
   while(FREAD1(dendescript,fd) == 1)
   {
      if (escpressed())
      {  *breaker = TRUE;
         break;
      }       
      onediagram(&dendescript);
      writestatistic();
   } 
   
   fclose(fd);
   unlink(fd_name);
}  /*  WriteSubprocess  */


static void  sim(int placeswap,int placesub,int howmanysub)
{
   
   writeF("%sSME=SBS%s%d(%d,%d)\n",SIX,ext,howmanysub,
                                                            placesub,nsub);

   writeF("%sCALL SWAP%s(%d,%d)\n",SIX,ext,placeswap + 1,
                                                            placeswap + 2);
   writeF("%sSME=(SME+SBS%s%d(%d,%d))/4\n",SIX,ext,howmanysub,
                                                            placesub,nsub);
}

static void  comby(prtclsarray name)
{int     bas[5];
 int		place[2], howmany[2];
 int		group, placeswap, placesub, howmanysub;
 int		i, j, n0;
 char        b[STRSIZ];
   bas[0] = 1; bas[1] = 2; bas[2] = 6; bas[3] = 24; bas[4] = 120;
   /* Nested function: sim */

   n0 = 1;
   i = 1;
   group = 0;

   while (i < nout)
   {
      j = i + 1;
      while (j <= nout && strcmp(name[i + nin-1],name[j + nin-1]) == 0)
         ++(j);
      if (j > i + 1)
      {
         ++(group);
         place[group-1] = nin + i - 1;
         howmany[group-1] = j - i;
         n0 = n0 * bas[j - i-1];
      }
      i = j;
   }
	if (group < 2) sbld(b,"%s%s",SIX,"SME");
   switch (group)
   {
      case 0:  writeF("%s=SMPL%s(%d)\n",
                  b,ext,nsub);
      break;

		case 1:  writeF("%s=SBS%s%d(%d,%d)/%d\n",
						b,ext,howmany[0],place[0],nsub,n0);
      break;

      case 2:  placeswap = place[0];
               placesub = place[1];
               howmanysub = howmany[1];
               if (howmany[0] != 2)
               {
                  placeswap = place[1];
                  placesub = place[0];
                  howmanysub = howmany[0];
               }
               sim(placeswap,placesub,howmanysub);
   }   /* Case */
}


static void  make_pinf(void)
{
   int         i;

   writeF(
      "%sFUNCTION PINF%s(NSUB,NPRTCL)\n",SIX,ext);
	writeF("%sCHARACTER*6 PINF%s,NAMES(%d,%d)\n",
      SIX,ext,subproc_sq,nin + nout);
   inftmp = inf;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      writeF("%sDATA ( NAMES(%d,I),I=1,%d)/",
         SIX,nsub,nin + nout);
      for (i = 1; i <= nin + nout; i++)
      {
         writeF("%c%s%c",39,inftmp->p_name[i-1],39);
         if (i == nin + nout)
            writeF("/\n");
         else
            writeF(",");
      }
      inftmp = inftmp->next;
   }
   writeF("%sPINF%s=NAMES(NSUB,NPRTCL)\n",SIX,ext);
   return_end();
}

static void  make_pmass(void)
{int  i;

   writeF("%sSUBROUTINE PMAS%s(NSUB,NPRTCL,VAL)\n",
      SIX,ext);
   implicitdeclaration();
	writeF("      DIMENSION NVALUE(%u,%d)\n",subproc_sq,nin + nout);
   common_vars();
   writeF("      SAVE\n");
   inftmp = inf;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      writeF("      DATA ( NVALUE(%d,I),I=1,%d)/",nsub,nin + nout);
      for (i = 0; i < nin + nout; i++)
      {  int k=inftmp->p_masspos[i];
         if(i) writeF(",");
         if(k) sscanf(vararr[k].alias,"A(%d)",&k);
         writeF("%d",k);
      }
      writeF("/\n");
      inftmp = inftmp->next;
   }
   writeF("%sN=NVALUE(NSUB,NPRTCL)\n",SIX);
   writeF("      IF (N.GT.%u) CALL INIT%s\n",nvars,ext);
   writeF("      IF (N.EQ.0)  THEN \n");
   writeF("         VAL=0\n");
   if (nvars + nfunc != 0)
   {
      writeF("      ELSE\n");
      writeF("         VAL=A(N)\n");
   }
   writeF("      IF(VAL.LT.0) VAL=-VAL\n");
   writeF("      ENDIF\n");
   return_end();
}

static void  make_sqme(void)
{
   writeF("%sFUNCTION SQME%s(NSUB,P)\n",SIX,ext);
   implicitdeclaration();
   writeF("%sDIMENSION P(0:3,%d)\n",SIX,nin+nout);
   common_scalararray(); 
   writeF("%sDOUBLE PRECISION SQME%s\n",SIX,ext);
   writeF("%sSAVE\n",SIX);
   
writeF( SIX "DO 1 J=2,%d\n",nin+nout);
writeF(SIX"DO 1 I=1,J-1\n");
writeF(SIX "  PP(I+((J-1)*(J-2))/2) ="); 
writeF(" P(0,I)*P(0,J)-P(1,I)*P(1,J)-P(2,I)*P(2,J)-P(3,I)*P(3,J)\n");
writeF("1     CONTINUE\n");
      
   writeF("%sCALL INIT%s\n",SIX,ext);
   inftmp = inf;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      writeF(SIX);
      if (nsub !=1) writeF("ELSE");
      writeF("IF(NSUB.EQ.%d) THEN\n",nsub);
      comby(inftmp->p_name);
      inftmp = inftmp->next;
   }
   writeF("%sEND IF\n",SIX);
   writeF("%sSQME%s=SME\n",SIX,ext);

   return_end();
}


static void  make_fosimple(void)
{unsigned        i, totcount;
 char        b[STRSIZ];
 int ll,len;
 
   writeF("%sFUNCTION SMPL%s(NSUB)\n",SIX,ext);
   implicitdeclaration();
   common_log();

   writeF("%sSAVE\n",SIX);
   inftmp = inf;
   totcount = 0;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      if (nsub == 1)
         writeF("%sIF(NSUB.EQ.%d) THEN\n",SIX,nsub);
      else
         writeF("%sELSE IF(NSUB.EQ.%d) THEN\n",SIX,nsub);

         writeF("%sS=0\n",SIX);
      
      
         if (inftmp->tot ) writeF("%sCALL D%d%s\n", SIX,nsub,ext);
         ll=80; 
         for (i = 1; i <= inftmp->tot; i++)
         {  
            sprintf(b,"+F%d%s()",totcount + i,ext);
            len=strlen(b)+1;
            if(len+ll>72) { writeF("\n%sS=S",SIX); ll=10;}
            writeF(b);
            ll+=len;            
         }
         writeF("\n");         
         totcount += inftmp->tot;
         inftmp = inftmp->next;
   }
   writeF("%sEND IF\n",SIX);
   writeF("%sL(NSUB)=1\n",SIX);
   writeF("%sSMPL%s=S\n",SIX,ext);
   return_end();     
}

static void  make_asgn(void)

{
   writeF("%sSUBROUTINE ASGN%s(NUMVAR,VALNEW)\n",
      SIX,ext);
	implicitdeclaration();
	writeF("%sDOUBLE PRECISION VALNEW\n",SIX);
   common_vars();
   writeF("%sSAVE\n",SIX);
   if (nvars > 0)
   {
      writeF(
         "%sIF((NUMVAR.LT.1).OR.(NUMVAR.GT.%d)) RETURN\n",SIX,nvars);
      writeF("%sA(NUMVAR)=VALNEW\n",SIX);
   }
   return_end();
}

static void  make_vinf(void)
{
   writeF("%sSUBROUTINE VINF%s(NUMVAR,NAME,VAL)\n",SIX,ext);
   implicitdeclaration();
   writeF("%sDOUBLE PRECISION VAL\n",SIX);
   common_vars();
   if (nvars != 0)
   {
      writeF("%sCHARACTER*6 NAMES(%d),NAME\n",SIX,nvars);
/*		writeF("%sDIMENSION  NUNIT(%d)\n",SIX,nvars); */
      writeF("%sSAVE\n",SIX);
      scanvars(3);
/*		scanvars(4); */
      writeF("%sIF (NUMVAR.GT.%d) RETURN\n",SIX,nvars);
      writeF("%sNAME=NAMES(NUMVAR)\n",SIX);
      writeF("%sVAL=A(NUMVAR)\n",SIX);
/*		writeF("%sNGEV=NUNIT(NUMVAR)\n",SIX); */
   }
   return_end(); 
} 

/*  $I FORTMAKE\addswap */   /*    addswap(......)  */

static void  addswap(void)
{char b[STRSIZ];

   writeF("%sFUNCTION SBS2%s(ISHFT,NSUB)\n",
      SIX,ext); 
   implicitdeclaration(); 
   writeF("%sSBS2%s=0\n",SIX,ext);
   writeF("%sDO 1 I=1,2\n",SIX);
   writeF("%sCALL SWAP%s(2+ISHFT,1+ISHFT)\n",SIX,ext);
   sbld(b,"%sSBS2%s",SIX,ext);
   sbld(b,"%s=SBS2%s",b,ext);
   writeF("%s+SMPL%s(NSUB)\n",b,ext);
   writeF("1      CONTINUE\n");
   return_end(); 

   writeF("%sFUNCTION SBS3%s(ISHFT,NSUB)\n",
      SIX,ext); 
   implicitdeclaration(); 
   writeF("%sSBS3%s=0\n",SIX,ext);
   writeF("%sDO 1 I=1,3\n",SIX);
   writeF("%sCALL SWAP%s(3+ISHFT,2+ISHFT)\n",
      SIX,ext); 
   sbld(b,"%sSBS3%s",SIX,ext);
   sbld(b,"%s=SBS3%s",b,ext);
   sbld(b,"%s+SMPL%s(NSUB)\n",b,ext);
   writeF("%s",b);
   writeF("%sCALL SWAP%s(3+ISHFT,1+ISHFT)\n",
      SIX,ext); 
   writeF("%s",b);
   writeF("1      CONTINUE\n");
   return_end(); 

   writeF("%sFUNCTION SBS4%s(ISHFT,NSUB)\n",SIX,ext);
   implicitdeclaration(); 
   writeF("%sSBS4%s=0\n",SIX,ext);
   writeF("%sDO 1 I=1,3\n",SIX);
   writeF("%sCALL SWAP%s(4+ISHFT,I+ISHFT)\n",
      SIX,ext); 
   sbld(b,"%sSBS4%s",SIX,ext);
   sbld(b,"%s =SBS4%s",b,ext);
   sbld(b,"%s+SBS3%s(ISHFT,NSUB)\n",b,ext);
   writeF("%s",b);
   writeF("%sCALL SWAP%s(4+ISHFT,I+ISHFT)\n",
      SIX,ext); 
   writeF("1      CONTINUE\n");
   sbld(b,"%sSBS4%s",SIX,ext);
   sbld(b,"%s=SBS4%s",b,ext);
   sbld(b,"%s+SBS3%s(ISHFT,NSUB)\n",b,ext);
   writeF("%s",b);
   return_end();

   writeF("%sFUNCTION SBS5%s(ISHFT,NSUB)\n",
      SIX,ext); 
   implicitdeclaration(); 
   writeF("%sSBS5%s=0\n",SIX,ext);
   writeF("%sDO 1 I=1,4\n",SIX);
   writeF("%sCALL SWAP%s(5+ISHFT,I+ISHFT)\n",
      SIX,ext); 
   sbld(b,"%sSBS5%s",SIX,ext);
   sbld(b,"%s=SBS5%s",b,ext);
   sbld(b,"%s+SBS4%s(ISHFT,NSUB)\n",b,ext);
   writeF("%s",b);
   writeF("%sCALL SWAP%s(5+ISHFT,I+ISHFT)\n",
      SIX,ext); 
   writeF("1      CONTINUE\n");
   writeF("%s",b);
   return_end(); 

   writeF("%sSUBROUTINE SWAP%s(I,J)\n",SIX,ext);
   implicitdeclaration();
   common_scalararray();
   writeF("%sSAVE\n",SIX);
   sbld(b,"%sDO 1 I0=1,NIN%s()+",SIX,ext);
   writeF("%sNOUT%s()\n",b,ext);
   writeF("%s  IF(I0.NE.I.AND.I0.NE.J)THEN\n",SIX);
   writeF("%s    A=PP(INDX%s(I0,I))\n",SIX,ext);
   writeF("%s    PP(INDX%s(I0,I))=PP(INDX%s(I0,J))\n",
      SIX,ext,ext);
   writeF("%s    PP(INDX%s(I0,J))=A\n",SIX,ext);
   writeF("%s  END IF\n",SIX);
	writeF("1%sCONTINUE\n",SIX);
   return_end();
}

static void zeroHeep(void)
{ goto_xy(1,1);print("Heep is empty!!!");inkey();
exit(0);
}


void  fortprg(int precision, char* extension)
{int breaker;

   memerror=zeroHeep;
   quadra = precision;
   ext=extension;
   outputLanguage='f';
  /* ======= Initialisation parth ======= */

   mark_(&heapbeg);

   archiv=fopen(ARCHIV_NAME,"rb");
   catalog=fopen(CATALOG_NAME,"rb");


   diagrq=fopen(DIAGRQ_NAME,"rb");

   initvararray(0,outputLanguage);

   
   firstVar=nmodelvar;
   if( !strcmp( modelvars[firstVar].varname,strongconst))  firstVar--; 
       
   prepareprocinform();

   calc_nvars_nfunc(); 
   

  /* ======= End of Initialisation ====== */
   outFileOpen(scat("%sresults%cservice.f",pathtouser,f_slash));   
   labl();

   geninf("NIN",nin);
   geninf("NOUT",nout);
   if (quadra)  geninf("LENR",16); else  geninf("LENR",8);
   geninf("NPRC",subproc_sq);

   make_pinf();
   
   geninf("NVAR",nvars);
   geninf("NFUN",nfunc);
   make_vinf();
   
   make_asgn();
   
	make_pmass();
	
/*	make_giw(); */
   writesubroutineinit();
	make_vini();
        make_cpth();
    outFileClose();

   outFileOpen(scat("%sresults%csqme.f",pathtouser,f_slash));
   labl();

   make_sqme();
   make_indx();
   addswap();
   make_fosimple();
   outFileClose();

   
   fseek(catalog,0,SEEK_END);
   ndiagrtot = ftell(catalog)/sizeof(catrec);

   diagrcount = 0;
   inftmp = inf;
   init_stat();

   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      if (inftmp->tot != 0)   /*  this subprocess IN archive  */
      {
         writesubprocess(nsub,&breaker);
         
         if (breaker) goto exi;
      }
      inftmp = inftmp->next;
   }

exi:
   clearstatistic();
   fclose(catalog);
   fclose(archiv);
   fclose(diagrq);
   release_(&heapbeg);
}
