/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"chep_crt.h"
#include "tptcmac.h"
#include "getmem.h"
#include "syst2.h" 
#include "physics.h"
#include "s_files.h"
#include "procvar.h"
#include "pvars.h"
#include "diaprins.h"
#include "optimise.h"
#include "l_string.h"
#include "parser.h"
#include "reader5.h"
#include "os.h"
#include "out_serv.h"
#include "saveres.h"
#include "denominators.h"
#include "c_out.h"


typedef char s6[7];


/*************************************************
 *     CompHEP (R) FORTRAN code production       *
 *          (C) S.Shichanin Febr 08 1991         *
 *                          June 17 1991         *
 *         Mass identifiers and values           *
 *************************************************/


#define procinfptr struct procinfrec *
typedef struct procinfrec
   {
      procinfptr     next;
      unsigned       tot;
      unsigned       firstdiagpos;
      prtclsarray    p_name;
      int            p_masspos[MAXINOUT];
   }  procinfrec;
#undef procinfptr
typedef struct procinfrec *procinfptr;




static procinfptr   inf, inftmp;  /*  information about subProcess  */


       /*  statictics  */
static unsigned         ndiagrtot, diagrcount;
static int      nvars, nfunc;

static marktp   heapbeg;/*  for RELEASE  */

static int      nden_w, nden_0, nsub1; /* from writesubprocess */


static void clearstatistic(void)
{int  i;
  for (i = 17; i < 24; i++) { goto_xy(1,i); clr_eol();}
}

static void init_stat(void)
{
   goto_xy(1,17);
   scrcolor(Yellow,Blue);
   print(" C Source Codes \n");
   scrcolor(Red,BGmain);
   print(" Process..........\n");
   print(" Total diagrams...\n");
   print(" Processed........\n");
   print(" Current..........\n");
   scrcolor(Yellow,Blue);
   print(" Press Esc to stop    ");
   scrcolor(Black,BGmain);
   goto_xy(20,18); print("%s",processch);
   goto_xy(20,19); print("%4u",ndiagrtot);
   goto_xy(20,20); print("   0");
   goto_xy(20,21); print("   1");
}


static void writestatistic(void)
{
   scrcolor(Black ,BGmain);
   goto_xy(20,19); print("%4u",ndiagrtot);
   goto_xy(20,20);
   print("%2u (%%)",(((diagrcount - 1) * 100) / ndiagrtot));
   goto_xy(20,21); print("%4u",diagrcount);
}


static void writpict(unsigned ndiagr)
{vcsect vcs;
   csdiagram  csdiagr;
   fseek(diagrq,ndiagr*sizeof(csdiagr),SEEK_SET);
   FREAD1(csdiagr,diagrq);
   transfdiagr(&csdiagr,&vcs);
   writeF("/*\n");
    DiagramToOutFile(&vcs,1,' ');
   writeF("*/\n");
}


static void labl(void)
{
  writeF("/*******************************\n");
  writeF("*    %s*\n",version);
  writeF("*******************************/\n");
}

  /* =========== Preliminary  calculations ================ */

static void calc_nvars_nfunc(void)
{  int   k;

   nvars = 0;
   nfunc = 0;

   for(k=1;k<=nmodelvar;k++)
   {  
      if (vararr[k].used)
      {if( modelvars[k].func) nfunc++; else  nvars++;}
   }      
}   /* Calc_Nvars_NFunc; */


static void prepareprocinform(void)
{int ndel, ncalc, nrest;
 long recpos;
 char        txt[STRSIZ];
 int     i, k;
 csdiagram   csd;
 s6          mass;
 int        nn;
 int nsubs;

   inf = NULL;
   menuq=fopen(MENUQ_NAME,"rb");
   for (nsubs=1;nsubs<=subproc_sq;nsubs++)
   {
      inftmp = inf;
      inf = (procinfptr)getmem_((unsigned)sizeof(procinfrec));
      inf->next = inftmp;
      rd_menu(2,nsubs,txt,&ndel,&ncalc,&nrest,&recpos);
      inf->firstdiagpos = recpos;
      getprtcls(txt,inf->p_name);
      for (i = 0; i < nin + nout; i++)
      {
         locateinbase(inf->p_name[i],&nn);
         strcpy(mass,prtclbase[nn-1].massidnt);
         if (strcmp(mass,"0")) for(k=1; strcmp(modelvars[k].varname,mass); k++); 
         else k=0;
         inf->p_masspos[i] = k;
      }
      for (i = nin + nout; i < MAXINOUT; i++)
      {
         strcpy(inf->p_name[i],"***");
         inf->p_masspos[i] = 0;
      }
      fseek(diagrq,recpos*sizeof(csdiagram),SEEK_SET);
      inf->tot = 0;
      for (i = 1; i <= ndel + ncalc + nrest; i++)
      {
         FREAD1(csd,diagrq);
         if (csd.status == 1) ++(inf->tot);
      }
   }
   nsubs--;
   fclose(menuq);
   revers((pointer*)&inf);
}


static void scanvars(int mode)
{
 int num=0;
 int k;

   for(k=1;k<=nmodelvar;k++)
   {  varlist  modl=modelvars+k;  
      if (vararr[k].used && !modl->func )
      {
         switch(mode)
         {
	    case 2:
	    {
               writeF("\n,%E",modl->varvalue);
               num++;
	    }
            break;

            case 3: writeF("\n,\"%s\"",modl->varname);                   
            break;

         }   /* CASE */
      }
   }
   
   for(k=1;k<=nmodelvar;k++)
   {  varlist  modl=modelvars+k;  
      if (vararr[k].used && modl->func )
      {
         switch(mode)
         {
	    case 2:
	    {
               writeF("\n,%E",modl->varvalue);
               num++;
	    }
            break;

            case 3: writeF("\n,\"%s\"",modl->varname);                   
            break;

         }   /* CASE */
      }
   }

}



  /* =========== Common blocks Emit =========== */

static void common(char * extern_)
{
 if(strcmp(extern_,"extern")) 
 {
   writeF(" double va[%d] ={",nvars+nfunc+1);
   if (nin > 1) writeF("%E",sqrts);else writeF("0");
   scanvars(2);
   writeF("};\n");
   
 }
 else  writeF("%s double va[%d];\n",extern_,nvars+nfunc+1);
      
}


  /* ======= Information functions =========== */

static void geninf(char* name,int value)
{
   writeF("const int %s = %d;\n\n",name, value);
}




static void  writesubroutineinit(void)
{
   int         l;
   char        *ss;
   char d_type[20];

   writeF("\nstatic double sqrt_e(double x, int * err)\n{");
   writeF("  if(x<0) {*err=(-1); return 0;} else return sqrt(x);\n}\n"); 
   
   strcpy(d_type,"double");
   writeF("int calcFunc(void)\n{\n");
   writeF("int err=0;\n");
   

   for(l=1;l<=nmodelvar;l++)
   {
      if ( vararr[l].used &&  modelvars[l].func )
      {	 ss=(char *)readExpression(modelvars[l].func,bact5,uact5,rd5);
	 writeF("   %s=%s;\n",vararr[l].alias,ss+3);
	 free(ss);
/*     writeF("   if(isnan(%s)) return FUCTION_ERROR;\n",varstxt[l]); */
      }
   }   
   writeF("if(err) return 1; else return 0;\n}\n"); 
}


static void  onediagram(deninforec * dendescript)
{catrec      cr;
 int         i,k;
 marktp      bh;
 varptr      totnum, totdenum, rnum;
 int     addpr;
 int numm;
 long pos_c;
 int deg1,deg2,nConst;

   mark_(&bh);
   tmpNameMax=0;
   initfortwriting('c');
   initdegnames();
   
   fseek(catalog,dendescript->cr_pos,SEEK_SET);
   FREAD1(cr,catalog);
   ++(diagrcount);

   outFileOpen(scat("%sresults%ccf%d.c",pathtouser,f_slash,diagrcount));

   writeF("extern double * Q0, *Q1,*Q2;\n");
   common("extern");
   writeF("#include\"out_ext.h\"\n");
   writeF("#include\"out_int.h\"\n");   
   writeF("#include\"f_c.h\"\n");


   labl();
   writeF("FNN F%d;\n",diagrcount);    
   writeF("double F%d(void)\n{\n",diagrcount);

   writpict(cr.ndiagr_ + inftmp->firstdiagpos - 1);

   writeF("double TOTNUM,TOTDEN,RNUM;\n");
   pos_c= ftell(outFile); writeF("%80s\n","");
   
   fseek(archiv,cr.factpos,SEEK_SET);
    
   readvardef();
   readpolynom(&totnum);
   readpolynom(&totdenum);
   clearvardef();
   
   fseek(archiv,cr.rnumpos,SEEK_SET);

   readvardef();
   readpolynom(&rnum);
   clearvardef();
   
   writeF("if(calcCoef[%d])\n{\n",cr.nsub_);

   nConst=write_const();
   
   writeF("}\n");
   deg1=cleardegnames();
   initdegnames();	
   
   fortwriter("TOTNUM",totnum);
   fortwriter("TOTDEN",totdenum);
   fortwriter("RNUM",rnum);
   
   writeF("return RNUM*(TOTNUM/TOTDEN)");


   for (i = 1; i <= dendescript->tot_den; i++)
   {  numm =
         dendescript->denarr[i-1].width ?
         dendescript->denarr[i-1].order_num:
         dendescript->denarr[i-1].order_num + nden_w;
      if (dendescript->denarr[i-1].power == 1) writeF("*Q1[%d]",numm);
                                             else writeF("*Q2[%d]",numm);
   }


	for (k = 1; k <= nden_w; k++)
	{
           addpr = TRUE;
           for (i = 1; i <= dendescript->tot_den; i++)
           if (dendescript->denarr[i-1].width &&
		     k == dendescript->denarr[i-1].order_num)  addpr = FALSE;
           if (addpr)  writeF("*Q0[%d]",k);
        }
     
   writeF(";\n}\n\n");

   deg2=cleardegnames();
   deg1=MAX(deg1,deg2);

   if(nConst || deg1 || tmpNameMax )
   {
      fseek(outFile,pos_c,SEEK_SET);
      if(nConst) writeF("static double C[%d];",nConst);
      if(deg1) writeF("double S[%d];",deg1);
      if(tmpNameMax) writeF("double tmp[%d];",tmpNameMax );
   }
   outFileClose();
   release_(&bh);
}

static void  writesubprocess(int nsub,int* breaker)
{  denlist    den_, den_tmp;
   int      i;
   deninforec   dendescript;
   FILE * fd;                /* file of (deninforec)  */
   char fd_name[STRSIZ];
   marktp mem_start;

   nsub1 = nsub;
   
   outFileOpen(scat("%sresults%ccd%d.c",pathtouser,f_slash,nsub));
   labl();

   writeF("#include\"out_int.h\"\n");
   writeF("#include\"out_ext.h\"\n");   
   writeF("#include\"f_c.h\"\n");
   
   writeF("extern double *Q0,*Q1,*Q2;\n");
   common("extern"); 

   writeF("DNN  d_%d;\n",nsub);
   
   writeF("int d_%d(double * momenta)\n{",nsub);

   writeF("int I,err=0;\n");
   writeF("double s0max=0;\n");

   sprintf(fd_name,"%stmp%cden.inf",pathtouser,f_slash);
   fd=fopen(fd_name,"wb"); 

   mark_(&mem_start);
   denominatorStatistic(nsub, &nden_w, &nden_0, &den_, fd); 
   fclose(fd);

   if(nden_w!=0) 
   { 
      writeF(" double DMASS[%d],DWIDTH[%d];\n",nden_w+1,nden_w+1);
      writeF(" if(Q0!=NULL) free(Q0);\n");
      writeF(" Q0=(double*)malloc(sizeof(double)*%d);\n",nden_w+1);
   }
   
   writeF(" for(I=0;I<nin_;I++) s0max=MAX(s0max,momenta[4*I]);\n");
   writeF("   s0max=1.E-15*s0max*s0max;\n");

   if(nden_w+nden_0!=0) 
   { 
      writeF(" if(Q1!=NULL) free(Q1);\n");
      writeF(" if(Q2!=NULL) free(Q2);\n");
      writeF(" Q1=(double*)malloc(sizeof(double)*%d);\n",nden_w+nden_0+1);
      writeF(" Q2=(double*)malloc(sizeof(double)*%d);\n",nden_w+nden_0+1);
   }

   while (den_ != NULL)
   {   int m=0;
       i=den_->order_num;
       if (den_->width)
       {
          writeF("DMASS[%d]=%s;\n",i,vararr[den_->mass].alias);   
          writeF("DWIDTH[%d]=%s;\n",i,vararr[den_->width].alias);
       }else i+=nden_w;
       writeF("Q1[%d]=",i);
       if(den_->mass!=0) 
       writeF("%s*%s",vararr[den_->mass].alias,vararr[den_->mass].alias);
       
       writeF("- sqrMom(\"");
       while(den_->momStr[m]) writeF("\\%o",den_->momStr[m++]);
       writeF("\",momenta);\n");             
       den_tmp=den_;
       den_ = den_->next; 
   }  
   
   release_(&mem_start); 
   if (nden_w > 0)
   {
      writeF( "for ( I=1;I<= %d;I++)\n {\n", nden_w);
      writeF( "if (rwidth)");
      writeF(
 "  Q2[I]=1/(pow_dl(Q1[I],2)+pow_dl((DMASS[I]-Q1[I]/DMASS[I])*DWIDTH[I],2));\n");
      writeF( "else");
      writeF( "  Q2[I]=1/(pow_dl(Q1[I],2)+pow_dl(DMASS[I]*DWIDTH[I],2));\n");
      writeF( "if (gwidth)");
      writeF( "  Q0[I]=Q2[I]*pow_dl(Q1[I],2);\n"); 
      writeF( "else");
      writeF( "  Q0[I]=1; \n");
      writeF( "  Q1[I]=Q2[I]*Q1[I];\n");
      writeF( "  }\n");
   }

   if (nden_0 > 0)
   {
      writeF( "for ( I=%d; I<=%d;I++)\n  {\n", 1+nden_w, nden_w + nden_0);
      writeF( "  if( ABS(Q1[I]) < s0max) {err=DENOMINATOR_ERROR;Q1[I]=-s0max;}\n");
      writeF( "  Q1[I]=1/Q1[I];\n");
  
      writeF( "  Q2[I]=pow_dl(Q1[I],2);\n");
      writeF( "  }\n");
   }
  /* ===================== */
   writeF("return err;\n");
   writeF("}\n");

   outFileClose();
   fd=fopen(fd_name,"rb");
   *breaker = FALSE;
   while(FREAD1(dendescript,fd) == 1)
   {
      if (escpressed())
      {  *breaker = TRUE;
         break;
      }
      onediagram(&dendescript);
      writestatistic();
   } 
   
   fclose(fd);
   unlink(fd_name);
}  /*  WriteSubprocess  */



static void  make_pinf(void)
{
   int    i;

   writeF("int pinf_(int nsub,int nprtcl,char * pname, double * pmass)\n{\n");
   writeF("int n;\n");
   writeF(" char names[%d][%d][7] =\n{",subproc_sq,nin + nout);

   inftmp = inf;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      for (i = 1; i <= nin + nout; i++)
      {
         writeF("\"%s\"",inftmp->p_name[i-1]);
         if (i == nin + nout)
            if(nsub==subproc_sq) writeF("\n};\n");
               else              writeF("\n,");
         else
            writeF(",");
      }
      inftmp = inftmp->next;
   }
   writeF("int nvalue[%d][%d]={\n",subproc_sq,nin + nout);

   inftmp = inf;
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {

      for (i = 1; i <= nin + nout; i++)
      {  int k=inftmp->p_masspos[i-1];
      
         if(k) sscanf(vararr[k].alias,"va[%d]",&k);
	 writeF("%d",k);
         if (i != nin + nout ||  nsub != subproc_sq  )  writeF(",");
         if (i == nin + nout)   writeF("\n");
      }
      if (nsub== subproc_sq) writeF("};\n");
      inftmp = inftmp->next;
   }


   writeF("if  (nsub<0 ||nsub>%d||nprtcl<0||nprtcl>%d) return 1;\n",
   subproc_sq,nin + nout);
   writeF("if(pname) strcpy(pname,names[nsub-1][nprtcl-1]);\n");

   writeF("if(pmass)\n{\n");
   writeF("  n=nvalue[nsub-1][nprtcl-1];\n");

   writeF("if (n>%d) if (calcFunc()) return FUCTION_ERROR;\n",nvars);
   writeF("if (n==0) *pmass=0; else *pmass=va[n];\n"); 
   writeF("if (*pmass<0) (*pmass)=-(*pmass);\n");  
   writeF("}\n");   
   writeF("return 0;\n}\n\n");
}


static void  make_fosimple(void)
{unsigned        i, totcount;

   writeF("static double smpl(int nsub,double*momenta,int * err)\n{\n");
   writeF(" double ans=0;\n"); 

   inftmp = inf;
   totcount = 0;
   
   writeF("switch(nsub)\n{\n");
   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      if (inftmp->tot != 0)
      {
         writeF("case %d: *err=*err|d_%d(momenta); sprod_(momenta); ans= ",nsub,nsub);          
         for (i = 1; i <= inftmp->tot; i++)  writeF("+F%d()",totcount+i);
         totcount += inftmp->tot;
         writeF(";\n     break;\n");
      }
      inftmp = inftmp->next;
   }   
   writeF("}\nreturn ans;\n}\n");
}


static void  make_asgn(void)
{
   writeF("int asgn_(int numvar,double newval)\n{\n");
   if (nvars > 0)
   {
      writeF("  if(numvar < 0|| numvar>%d) return 1;\n",nvars);
      writeF("   va[numvar]=newval;\n");
   }
   writeF("   return 0;\n");
   writeF("}\n\n");                                                 
}

static void  make_vinf(void)
{
   writeF("int vinf_(int numvar,char * name,double * val)\n{\n");
 
   writeF("char names[%d][10]={\"Sqrt(S)\"",nvars+nfunc+1);
   scanvars(3);
   writeF("};\n");
   writeF("   if(numvar<0||numvar>%d  ) return 1;\n",nvars+nfunc);
   writeF("   if(name) strcpy(name,names[numvar]);\n");
   writeF("   if(val) *val=va[numvar];\n");
 
   writeF("   return 0;\n}\n\n");
}



static void zeroHeep(void)
{ goto_xy(1,1);print("Heep is empty!!!");inkey();
exit(0);
}


int  c_prog(void)
{  int breaker;
   int i;
   
   outputLanguage='c';
   catalog=fopen(CATALOG_NAME,"rb");
   archiv=fopen(ARCHIV_NAME,"rb");
   diagrq=fopen(DIAGRQ_NAME,"rb");

   memerror=zeroHeep;
   mark_(&heapbeg);
   initvararray(0, outputLanguage);
  /* ======= Initialisation parth ======= */


   firstVar=nmodelvar;
   if( !strcmp( modelvars[firstVar].varname,strongconst))  firstVar--;
   
   prepareprocinform();
   calc_nvars_nfunc();
  /* ======= End of Initialisation ====== */
   outFileOpen(scat("%sresults%ccservice.c",pathtouser,f_slash)); 
   
   labl();

   writeF("#include\"out_int.h\"\n");
   writeF("#include\"out_ext.h\"\n");
   writeF("#include\"f_c.h\"\n");


   writeF("int gwidth=0;\n");
   writeF("int rwidth=0;\n");


   common("");
      
   geninf("nin_",nin);
   geninf("nout_",nout);
   geninf("nprc_",subproc_sq);
   make_pinf();
   geninf("nvar_",nvars);
   geninf("nfunc_",nfunc);

   make_vinf();
   make_asgn(); 
   writesubroutineinit(); 

   outFileClose();

   outFileOpen(scat("%sresults%ccsqme.c",pathtouser,f_slash));
   labl();

   common("extern");

   writeF("#include\"out_int.h\"\n");
   writeF("#include\"out_ext.h\"\n");
   writeF("char  processch[] = \"%s\";\n",processch);
   writeF("double DP[%d];\n", ((MAXINOUT*(MAXINOUT-1)/2)));
    
   writeF("extern DNN ");
   for(i=1;i<subproc_sq;i++)  writeF("d_%d,",i); 
   writeF("d_%d;\n",subproc_sq); 


   fseek(catalog,0,SEEK_END);
   ndiagrtot = ftell(catalog)/sizeof(catrec);

   writeF("extern FNN ");
   for(i=1;i<ndiagrtot;i++)  writeF("F%d,",i); 
   writeF("F%d;\n",ndiagrtot); 
   writeF("static void sprod_(double*);\n");         
   make_fosimple();

   writeF("#include\"sqme0.c\"\n");
      
   outFileClose();

   diagrcount = 0;
   inftmp = inf;
   init_stat();

   for (nsub = 1; nsub <= subproc_sq; nsub++)
   {
      if (inftmp->tot != 0)   /*  this subprocess IN archive  */
      {
         writesubprocess(nsub,&breaker);
         if (breaker) goto exi;
      }
      inftmp = inftmp->next;
   }

exi:
   clearstatistic();
   fclose(catalog);
   fclose(archiv);
   fclose(diagrq);
   release_(&heapbeg);
   return !breaker; 
}
