/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"chep_crt.h"
#include "tptcmac.h"
#include "syst2.h"
#include "physics.h"
#include "screen.h"
#include "s_files.h"
#include "file_scr.h"
#include "read_mdl.h"
#include "os.h"

#include "m_utils.h"


#define nhardmdl 4
#define newmodeltxt " CREATE NEW MODEL     "

#define MAX_MODEL_NUM  ((STRSIZ-2)/22 -1)
  
void fillModelMenu(void)
{ int i,j;
  FILE * txt;
  char name[80];
  strcpy(modelmenu,"\026");
  maxmodel=0;
  for (i=1;i<=MAX_MODEL_NUM; i++)
  { 
     txt=fopen(scat("%smodels%c%s%d.mdl",pathtouser,f_slash,mdFls[0],i),"r");		
     if (txt==NULL) goto exi;
     fgets(name,60,txt);
     trim(name);
     for (j=strlen(name); j<21;j++) name[j]=' ';
     name[21]=0;
     strcat(modelmenu," ");
     strcat(modelmenu,name);
     fclose(txt);
     maxmodel++;
  }
  exi: 
  if ( maxmodel < MAX_MODEL_NUM ) strcat(modelmenu,newmodeltxt) ;
}



int  deletemodel(int n)
{
 int   i;
 char from[STRSIZ],to[STRSIZ];
 searchrec  s;


    sprintf(from,"%smodels%c%s%d.mdl",pathtocomphep,f_slash,mdFls[0],n);

    if (find_first(from,&s,archive)==0)
    {
	if (mess_y_n(44,10,"This model can not be deleted.$Restore original version?$"))
	for (i=0;i<4;i++) 
	{ 
	   sprintf(from,"%smodels%c%s%d.mdl",pathtocomphep,f_slash,mdFls[i],n);
	   sprintf(to,"%smodels%c%s%d.mdl",pathtouser,f_slash,mdFls[i],n);
	   copyfile(from,to);
	}	
	else  return  FALSE;
	}
	else
	if ( mess_y_n(56,10,"Delete model?$"))
        {
           for(i=0;i<4;i++)
           {
              sprintf(to,"%smodels%c%s%d.mdl",pathtouser,f_slash,mdFls[i],n);
	      unlink(to);
           }

           if (n < maxmodel)
           {    
	  for(i=0;i<4;i++)
	  {		  
	    sprintf(from,"%smodels%c%s%d.mdl",pathtouser,f_slash,mdFls[i],maxmodel);
	    sprintf(to,  "%smodels%c%s%d.mdl",pathtouser,f_slash,mdFls[i],n);
	    rename(from,to);	  
	  }
      }
      return TRUE;
   } 
   return FALSE;
}



int  makenewmodel(void)
{ shortstr  newName;
  int       key, nmdl;
  int      npos=1, i;
 
  char oldModels[STRSIZ];
  void *pscr = NULL;
 
  strcpy(newName," ");
  do
  {  goto_xy(1,7); print("Model name :");
     key = str_redact(newName,npos,25);
  }while (key!=KB_ENTER &&  key!=KB_ESC);
  trim(newName);
  if (key == KB_ESC || strlen(newName) == 0) return FALSE;
  sbld(newName,"_%s",newName);
  nmdl = 1;
  strcpy(oldModels,copy(modelmenu,1,(int)strlen(modelmenu) - 22));
  menu1(5,10,"Choose a template",oldModels,NULL,&pscr,&nmdl);
  if (nmdl == 0) return FALSE;
  put_text(&pscr);
  readModelFiles (nmdl);
  for (i=0;i<4;i++) strcpy(modelTab[i].mdlName,newName);
  writeModelFiles (n_model);
  fillModelMenu();
  clrbox(5,10,30,12);
  return TRUE;
}


int  continuetest(void)
{shortstr  txt;
 int  k, ndel, ncalc, nrest; 
 long recpos;

   menuq=fopen(MENUQ_NAME,"rb");
  
   for(k=1;k<=subproc_sq;k++)
   {
      rd_menu(2,k,txt,&ndel,&ncalc,&nrest,&recpos);
      if (nrest != 0)
      {
         fclose(menuq);
         return FALSE;
      }
   }
   fclose(menuq);
   return TRUE;
}


void  clear_tmp(void)
{  
   unlink(CATALOG_NAME);
   unlink(ARCHIV_NAME);
}

