/*
Author : A.Taranov  
*/

#include<stdio.h>
#include "process.h"
#include "sortarr.h"
#include "diagrams.h"


/*  transformation of diagr representation  */ 

#define vacantvert 252 /*# of vacant vert                          */ 
#define notassignmom 0 /* from labelmom */


static vampl *      vlist;               /*  from mkverts       */

static decayDiagram     diag;                /*  from mkverts       */

static int         vvalence[maxvert];   /*  first free valence */ 
                                         /*  from mkverts       */
static int         decayclock;          /*  decay level ( from Pukhov) */ 
                                         /*  from mkverts       */
static int         ii, jj, j0, kk, yetin;  /*  from mkverts       */
                       /*  how many in-edges not processed yet  */ 
                       
static int   nextv(int v)
/*  seeks backward first unused vertex */ 
{ 
 while (!((vvalence[v-1] < MAXVALENCE) || 
        (vlist->vertlist[v-1][MAXVALENCE-1].nextvert.vno == 
         vacantvert)) && (v > 1)) --(v); 
  return v; 
}   /* nextV */ 

static void         inwardedge(void)
  /*   Processing inWard edge in aDiagram  */ 
  { 
    --(decayclock); 
    /* **** Expanded  Vertex ****  */ 
      { edgeinvert *with1 = &vlist->vertlist[j0-1][vvalence[j0-1]-1]; 
         with1->partcl = -diag[ii-1];   /*  out of vertex  */ 
         with1->nextvert.vno = jj ; 
         with1->nextvert.edno = vvalence[jj-1]; 
      } 
        /*  With  */ 
    /*  *** next     Vertex ****  */ 
      { edgeinvert *with1 = &vlist->vertlist[jj-1][vvalence[jj-1]-1]; 
        with1->partcl = prtclbase[-diag[ii-1]-1].anti;   /*  into vertex  */ 
        with1->nextvert.vno = j0; 
        with1->nextvert.edno = vvalence[j0-1]; 
      } 
      /*  With  */ 
    ++(vvalence[j0-1]); 
    ++(vvalence[jj-1]); 
    j0 = jj;   /*  next vert to be expanded  */ 
    ++(jj);   /*  next  */ 
}   /* inword edge */ 


static void         outwardedge(void)
/*   Processing outWard edge in aDiagram  */ 
{ 
    ++(decayclock); 
    /* **** Expanded  Vertex ****  */ 
    { edgeinvert *with1 = &vlist->vertlist[j0-1][vvalence[j0-1]-1]; 
       with1->partcl = diag[ii-1]; 
       if (yetin > 0) 
         { 
           --(yetin); 
           with1->prop = IN_PRTCL; 
           vlist->outer[kk-1].vno = j0 ; 
           vlist->outer[kk-1].edno = vvalence[j0-1]; 
           with1->nextvert.vno = nullvert; 
           with1->nextvert.edno = kk; 
           ++(kk); 
         } 
       else 
         {   /*  intr vertex  */ 
           /* *** pointer to intr edge ***  */ 
           vlist->outer[kk-1].vno = j0; 
           vlist->outer[kk-1].edno = vvalence[j0-1]; 
           /* - - - - - - - - -   -  - - -  */ 
           with1->prop = OUT_PRTCL; 
           with1->nextvert.vno = nullvert; 
           with1->nextvert.edno = kk;
           ++(kk); 
            
         }   /* else */ 
      } 
     /* With */ 
   ++(vvalence[j0-1]); 
   j0 = nextv(j0); 
}   /*  outwardEdge  */ 


static void         auxedge(void)
/*   Processing auxiliarry edge in aDiagram  */ 
{ 
    --(decayclock); 
    vlist->vertlist[j0-1][MAXVALENCE-1].nextvert.vno = vacantvert; 
    /*  to indicate 4-vertex  */ 
}   /*  auxEdge  */ 


  /*  ************************** Main program ******************************* */ 

  /*  if TRUE then conjugate diagr  */ 


#ifdef DEBUG
static 
void printDiagram(vampl * vlist)
{

int i,j;

for(i=0;i< vlist->size;i++)
{
  for(j=0;j< MAXVALENCE && vlist->vertlist[i][j].partcl ; j++)
  {
    printf("vertex=%d, line=%d, prtcl=%s  link(%d,%d) \n",
 i+1,j+1,prtclbase[vlist->vertlist[i][j].partcl-1].name,

 vlist->vertlist[i][j].nextvert.vno,vlist->vertlist[i][j].nextvert.edno
 
  ); 
  
  }

  printf("\n");
}

 for(i=0;i<vlist->outno;i++)
 
printf("%d=(%d,%d) ",i+1, vlist->outer[i].vno,vlist->outer[i].edno); 

 printf("\n\n");
}


static 
void printCsDiagram(vcsect * vlist)
{

int i,j;

for(i=0;i< vlist->sizet;i++)
{
  for(j=0;j< vlist->valence[i] ; j++)
  { edgeinvert *v=&vlist->vertlist[i][j],
    *av=&vlist->vertlist[v->nextvert.vno-1][v->nextvert.edno-1];
  
 printf("vertex=%d, line=%d, prtcl=%s  link(%d,%d) moment=%d,lorentz=%d prop=%d \n",
 i+1,j+1,prtclbase[v->partcl-1].name,

 v->nextvert.vno,v->nextvert.edno, v->moment,v->lorentz, v->prop
 
  ); 
  
  }

  printf("\n");
}


 printf("\n\n");
}


#endif
                  
void  mkverts(decayDiagram diag1,vampl* vlist1)
{    
   int i,j;
   
   vlist = vlist1;
   for(i=0;i< ldiagram;i++)diag[i]=diag1[i];

     for(i=0;i<maxvert;i++)
     { vlist->valence[i]=0;
       vvalence[i] = 1; 
     
       for (j = 0; j < MAXVALENCE; j++) 
       { edgeinvert * v= &( vlist->vertlist[i][j]);
         v->nextvert.vno = nullvert;
         v->nextvert.edno= nullvert;
         v->lorentz=0; 
         v->partcl = 0;
         v->prop=0;
         v->moment=0; 
       } 
     }
     
     decayclock = -1;   
     /*  for checking the end of aDiagram must be 1  */ 
     ii = 1;   /*  edge counter  */ 
     j0 = 1;   /*  vertex to be expanded  */ 
     jj = 2; 
     kk = 1; 
     yetin = nin - 1;   /*  counter for in particles  */ 

  { edgeinvert *with1 = &vlist->vertlist[j0-1][vvalence[j0-1]-1];   
  /*  process 1st edge  */ 
    with1->partcl = prtclbase[-diag[ii-1]-1].anti; 
    with1->prop = IN_PRTCL; 
    with1->nextvert.vno = nullvert; 
    with1->nextvert.edno = kk; 
    vlist->outer[kk-1].vno = j0; 
    vlist->outer[kk-1].edno = vvalence[j0-1]; 
    ++(kk); 
    ++(ii); 
    ++(vvalence[j0-1]); 
     } 
    /*  With  */ 

  /*  *** main cycle *********  */ 
   do { 
    if (diag[ii-1] < 0) inwardedge(); 
    else if (diag[ii-1] > 0) outwardedge(); 
    else if (diag[ii-1] == 0) auxedge(); 
    ++(ii); 
   }  while (!(decayclock > 0)); 
   vlist->outno = kk - 1; 
   vlist->size = jj - 1; 
   

   for(i=0;i<vlist->size;i++)
   { int val=MAXVALENCE;
      while (val && (vlist->vertlist[i][val-1].partcl == 0)) val--; 
      vlist->valence[i] = val;
   }
   
}   /* ==========mkVerts =========== */ 



static void  mkcsections(csdiagram* diagr,vcsect* vcs)
/*  constructs vertex-oriented strukture for cross sektion diagramm  */ 
{ 
   int i,j, shift; 
   vertlink   buff[MAXINOUT]; 
   vampl        va1, va2; 


   vcs->symnum   = diagr->mult; 
   vcs->symdenum = diagr->del; 
   
   mkverts(diagr->dgrm1,&va1); 
/*printDiagram(&va1); */
   vcs->sizel = va1.size; 
   for (i = 0; i < va1.size; i++) 
   { vcs->valence[i]=va1.valence[i];
     for(j=0;j<MAXVALENCE;j++) 
     vcs->vertlist[i][j] =  va1.vertlist[i][j]; 
   }

   mkverts(diagr->dgrm2,&va2); 
/*printDiagram(&va2);*/
   for(i=0;i<va2.outno;i++) buff[i]=va2.outer[i]; 
   for(i=nin;i<va2.outno;i++)
   va2.outer[i]=buff[nin+ diagr->lnk[i-nin]-1 ];

/*printDiagram(&va2);*/


   shift=va1.size;
   vcs->sizet = va2.size+shift;
   for (i = 0; i < va2.size; i++) 
   { vcs->valence[i+shift]=va2.valence[i];
     for(j=0;j<MAXVALENCE;j++) 
     vcs->vertlist[i+shift][j]= va2.vertlist[i][j]; 
   }
   
   for(i=vcs->sizel;i<vcs->sizet;i++)
   for(j=0;j<vcs->valence[i];j++)
   {  edgeinvert * v=&vcs->vertlist[i][j];  
      v->partcl = prtclbase[v->partcl-1].anti; 
      if(v->nextvert.vno !=nullvert) v->nextvert.vno +=shift; 
   }


   for(i=0;i< va1.outno;i++)
   { vcs->vertlist[va1.outer[i].vno-1][va1.outer[i].edno-1].nextvert.vno=
   va2.outer[i].vno+shift;
   vcs->vertlist[va1.outer[i].vno-1][va1.outer[i].edno-1].nextvert.edno=
      va2.outer[i].edno;

   vcs->vertlist[va2.outer[i].vno+shift-1][va2.outer[i].edno-1].nextvert=
   va1.outer[i];
   }
} 

  /* ====================================== mkCSections=======  */ 
  /*    labelling diagramm with momentums       */ 
  /*    This procedures labels cross-section diagramm with               */ 
  /*    momenta and lorentz ind.                                         */ 
  /*    Momenta coded with numbers stored in                             */ 
  /*       vCSect.vertList[vertex,edge].moment                           */ 
  /*    Positive number means outgoing momentum, negative - ingoing.     */ 
  /*    Linear relations are stored in vCSect.linear[vertex]             */ 
  /*    as array of momenta with zero sum. Independent - in 1st place    */ 
  /*    Linear relations must be supplemented with relation, describing  */ 
  /*    dependence of external momenta of the amplitude.                 */ 
  /*    Lorentz ind coded with bytes are stored in                       */ 
  /*     vCSect.vertList[vertex,edge].lorentz                            */ 
  /* ******************* A.Taranov    24.07.89 ------------------------- */ 



static void   assignlor(vcsect* vcs)
{
   int  lorcnt=1,i,j;

   for (i = 0; i < vcs->sizet; i++) 
   for (j = 0; j < vcs->valence[i]; j++) 
   { edgeinvert *  v=&vcs->vertlist[i][j],
     * av=&vcs->vertlist[v->nextvert.vno-1][v->nextvert.edno-1]; 

      if (vectorp(v->partcl)&& (v->nextvert.vno-1 > i) )
      { 
         v->lorentz = lorcnt; 
        av->lorentz = lorcnt; 
        ++(lorcnt); 
      } 
   } 
}   /*  assignLor  */ 


/* ********************main program ************************************** */ 

static void  labelmom(vcsect* vcs1)
{  int  i, j, momcnt, inmom,virtmom, outlst[MAXINOUT]; 
    
   /* ------------------ make list out particles ---------------------- */
   momcnt=0;
   for (i = 0; i < vcs1->sizel; i++)
   for (j = 0; j < vcs1->valence[i]; j++)
   { edgeinvert *  ln=&vcs1->vertlist[i][j];
     if (ln->prop & OUT_PRTCL ) outlst[momcnt++] = ln->partcl;
   }
   /* ---------------- sort List out particles -------------------------- */
     SORTARR(outlst,nout);
   /* ------------------ assign out momentum ----------------------------- */ 
   inmom=1;
   virtmom=nin+nout+1;
   for (i = 0; i < vcs1->sizet; i++) 
   for (j = 0; j < vcs1->valence[i]; j++) 
   { edgeinvert *  v=&vcs1->vertlist[i][j];
     edgeinvert * av=&vcs1->vertlist[v->nextvert.vno-1][v->nextvert.edno-1]; 
     if (i<vcs1->sizel && ( v->prop & OUT_PRTCL))     /* out particles */
     {  int   nprtcl  = v->partcl; 
        int pos=0;
   
        while (outlst[pos] != nprtcl) pos++;
        outlst[pos] = 0;
        v->moment  = pos+nin+1;    
        av->moment = -v->moment; 
     }else if(i<vcs1->sizel && (v->prop & IN_PRTCL))  /* in particles */
     {
        v->moment = -inmom++;   
        av->moment = -v->moment; 
     }else if ( !(v->prop & (IN_PRTCL|OUT_PRTCL))  && i<v->nextvert.vno-1)
     {   v->moment=virtmom++;     
        av->moment=-v->moment;
     }  
     
   }  /* assignOutMom */ 

}   /* ================================================== labelMom======== */ 



void   transfdiagr(csdiagram* diag,vcsect* vcs)
{ 

   mkcsections(diag,vcs);   /*  make cross section diagramm  */ 
   labelmom(vcs);           /*  label it with moments        */ 
   assignlor(vcs);          /*  label it with  Lorentz ind   */ 
#ifdef DEBUG                            
   printCsDiagram(vcs);
#endif
}   /*   transfDiagr  */ 


void InOutPrtclsNumb( decayDiagram a, int * numb, int sort )
{
  int i=1, k=1;

  numb[0]=-a[0]; 
  for (;i<2*(nin+nout)-3;i++) {if(a[i]>0) numb[k++] = a[i];}
  if(nin==2) numb[1]=prtclbase[numb[1]-1].anti;
    
  if(sort) SORTARR((numb+nin) ,nout)

}  

void proccessName(decayDiagram a, char * txt )
{ int k;
  int buff[MAXINOUT];
  InOutPrtclsNumb( a, buff,1);

  txt[0]=0;

  for(k=0;k<nin;k++)
  {  strcat(txt, prtclbase[buff[k]-1].name);
     if(k<nin-1) strcat(txt,",");
  }
  strcat(txt,"->");
   
  for(k=nin;k<nin+nout;k++)
  {  strcat(txt, prtclbase[buff[k]-1].name);
     if(k<nin+nout-1) strcat(txt,",");
  }
}



