/*
Copyright (C) 1997, Alexander Pukhov
*/

#include <ctype.h>
#include <math.h>
#include <string.h>
#include "parser.h"
#include "read_func.h"
#include "getmem.h"


static int (*nameToVal)(char *,double *);


static void*  rd_func(char* s)
{
   double    * p;

   p = (double *) getmem_(sizeof(double)); 
   
   if(!nameToVal) {fprintf(stderr,"Error in programming, nameToVal==NULL\n"); exit(1);}
         
   if( (*nameToVal)(s,p))  return (void*)p; else 
   { 
      if(isdigit(*s))  rderrcode=typemismatch;else rderrcode=16; 
      return NULL; 
   }
}


static void*  uact_func(char* ch,void* mm)
{double  * p;

   p = (double *)mm;
   if (strcmp(ch,"-") == 0)
   {  *p = - *p;
      return mm;
   }
   /* If ch='Sqrt' */
	if (*p <  0.0)
	{
	  rderrcode =  negativsqrtarg;
	  return  NULL;

	}
   *p = sqrt(*p);
   return mm;
}


static void*  bact_func(char ch,void* mm1,void* mm2)
{  double  * p1, *p2;

   p1 = (double *) mm1;
   p2 = (double *) mm2;
   switch (ch)
   {
      case '+':
         *p1 += *p2;
      break;

      case '*':
         *p1 *= *p2;
      break;

      case '/':
	  if (*p2 == 0)
	  {
	     rderrcode=divisionbyzero;
	     return NULL;
          }
         else
            *p1 /= *p2;
      break;

      case '^':
      
         if(floor(*p2)==*p2)
         {int i= abs(floor(*p2)); 
           double r=1;  
           for(;i;i--) r*=*p1;
           if(floor(*p2)>0) *p1=r; 
           else 
           { if(r==0) { rderrcode=divisionbyzero; return NULL; }
             *p1=1./r;
           }
           break;
         } 
      
	 if (*p1 <  0.0 || floor(*p2)!=*p2  )
	 {
	    rderrcode = negativsqrtarg;
	    return  NULL;                                  
	 }
	                                             
	*p1=pow(*p1,*p2);
         break;
      case '.' :
         rderrcode=unexpectedoperation;
         return NULL;  
         break;
	
   }  /* Case */
   return (void*) p1;
}


int calcExpression(char *s,int(*nameToDouble)(char *,double *), double *p)
{
  marktp  heapbeg;
  double * r;

  nameToVal=nameToDouble;

  mark_(&heapbeg);
  r = (double *)readExpression(s,bact_func,uact_func,rd_func);
  if(!rderrcode) *p=*r;
  release_(&heapbeg); 
           
  return rderrcode;
}          
