*    *****************************************
*
*			*  VEGAS  *
*
*    *****************************************


      BLOCK DATA
C
C   MAKES DEFAULT PARAMETER ASSIGNMENTS FOR VEGAS
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/BVEG1/NCALL,ITMX,NPRN,NDEV,XL(10),XU(10),ACC
      COMMON/BVEG2/IT,NDO,SI,SWGT,SCHI,XI(50,10)
      COMMON/BVEG3/ALPH,NDMX,MDS
      DATA NCALL/10000/,ITMX/15/,NPRN/5/,ACC/-1./,
     1     XL/0.,0.,0.,0.,0.,0.,0.,0.,0.,0./,
     2     XU/1.,1.,1.,1.,1.,1.,1.,1.,1.,1./,
     3     ALPH/1.5/,NDMX/50/,MDS/1/,NDEV/6/,
     4     NDO/1/,XI/500*1./,IT/0/,SI,SWGT,SCHI/3*0./
      END
      SUBROUTINE VEGAS0(NDIM,FXN,AVGI,SD,CHI2A)
C
C   SUBROUTINE PERFORMS NDIM-DIMENSIONAL MONTE CARLO INTEG'N
C      - BY G.P. LEPAGE    SEPT 1976/(REV)AUG 1979
C      - ALGORITHM DESCRIBED IN J COMP PHYS 27,192(1978)
C
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL RAND(10)
      DIMENSION D(50,10),DI(50,10),XIN(50),R(50),DX(10),IA(10),
     1          KG(10),DT(10),X(10)
      common/bveg1/ncall,itmx,nprn,ndev,xl(10),xu(10),acc
      COMMON/BVEG2/IT,NDO,SI,SWGT,SCHI,XI(50,10)
      COMMON/BVEG3/ALPH,NDMX,MDS
      COMMON/BVEG4/CALLS,TI,TSI

      SAVE
      EXTERNAL FXN

C     FACTOR FOR ERROR W/ 90 % CONFIDENCE LEVEL

      DATA FACTOR/1.65/
      DATA ONE/1./

C
      NDO=1
      DO 1 J=1,NDIM
1     XI(1,J)=ONE
C
      ENTRY VEGAS1(NDIM,FXN,AVGI,SD,CHI2A)
C         - INITIALIZES CUMMULATIVE VARIABLES, BUT NOT GRID
      IT=0
      SI=0.
      SWGT=SI
      SCHI=SI
C
      ENTRY VEGAS2(NDIM,FXN,AVGI,SD,CHI2A)
C         - NO INITIALIZATION
      ND=NDMX
      NG=1
      IF(MDS.EQ.0) GO TO 2
      NG=(NCALL/2.)**(1./NDIM)
      MDS=1
C*      IF((2*NG-NDMX).LT.0) GO TO 2
C*      MDS=-1
C*      NPG=NG/NDMX+1
C*      ND=NG/NPG
C*      NG=NPG*ND
2     K=NG**NDIM
      NPG=NCALL/K
      IF(NPG.LT.2) NPG=2
      CALLS=NPG*K
      DXG=ONE/NG
      DV2G=(CALLS*DXG**NDIM)**2/NPG/NPG/(NPG-ONE)
      XND=ND
      NDM=ND-1
      DXG=DXG*XND
      XJAC=ONE/CALLS
      DO 3 J=1,NDIM
      DX(J)=XU(J)-XL(J)
3     XJAC=XJAC*DX(J)
C
C   REBIN, PRESERVING BIN DENSITY
      IF(ND.EQ.NDO) GO TO 8
      RC=NDO/XND
      DO 7 J=1,NDIM
      K=0
      XN=0.
      DR=XN
      I=K
4     K=K+1
      DR=DR+ONE
      XO=XN
      XN=XI(K,J)
5     IF(RC.GT.DR) GO TO 4
      I=I+1
      DR=DR-RC
      XIN(I)=XN-(XN-XO)*DR
      IF(I.LT.NDM) GO TO 5
      DO 6 I=1,NDM
6     XI(I,J)=XIN(I)
7     XI(ND,J)=ONE
      NDO=ND
C
8     CONTINUE 

C
      ENTRY VEGAS3(NDIM,FXN,AVGI,SD,CHI2A)
C         - MAIN INTEGRATION LOOP
9     IT=IT+1
      TI=0.
      TSI=TI
      DO 10 J=1,NDIM
      KG(J)=1
      DO 10 I=1,ND
      D(I,J)=TI
10    DI(I,J)=TI
C
11    FB=0.
      F2B=FB
      K=0
12    K=K+1
      CALL RANDA(NDIM,RAND)
      WGT=XJAC
      DO 15 J=1,NDIM
      XN=(KG(J)-RAND(J))*DXG+ONE
      IA(J)=XN
      IF(IA(J).GT.1) GO TO 13
      XO=XI(IA(J),J)
      RC=(XN-IA(J))*XO
      GO TO 14
13    XO=XI(IA(J),J)-XI(IA(J)-1,J)
      RC=XI(IA(J)-1,J)+(XN-IA(J))*XO
14    X(J)=XL(J)+RC*DX(J)
15    WGT=WGT*XO*XND
C
      F=WGT
      F=F*FXN(X,WGT)
      F2=F*F
      FB=FB+F
      F2B=F2B+F2
      DO 16 J=1,NDIM
      DI(IA(J),J)=DI(IA(J),J)+F
16    IF(MDS.GE.0) D(IA(J),J)=D(IA(J),J)+F2
      IF(K.LT.NPG) GO TO 12
C
      F2B=DSQRT(F2B*NPG)
      F2B=(F2B-FB)*(F2B+FB)
      TI=TI+FB
      TSI=TSI+F2B
      IF(MDS.GE.0) GO TO 18
      DO 17 J=1,NDIM
17    D(IA(J),J)=D(IA(J),J)+F2B
18    K=NDIM
19    KG(K)=MOD(KG(K),NG)+1
      IF(KG(K).NE.1) GO TO 11
      K=K-1
      IF(K.GT.0) GO TO 19
C
C   COMPUTE FINAL RESULTS FOR THIS ITERATION
      TSI=TSI*DV2G
      TI2=TI*TI
      WGT=ONE/TSI
      SI=SI+TI*WGT
      SWGT=SWGT+WGT
      SCHI=SCHI+TI2*WGT
      AVGI=SI/SWGT
      CHI2A=(SCHI-SI*AVGI)/(IT-.9999)
      SD=DSQRT(ONE/SWGT)
      FNLERR=FACTOR*SD
C
      TSI=DSQRT(TSI)
      IF(NPRN.LT.0) GO TO 21
      ERR=FACTOR*TSI
      IF(NPRN.EQ.0) GO TO 21
C
C   REFINE GRID
21    DO 23 J=1,NDIM
      XO=D(1,J)
      XN=D(2,J)
      D(1,J)=(XO+XN)/2.
      DT(J)=D(1,J)
      DO 22 I=2,NDM
      D(I,J)=XO+XN
      XO=XN
      XN=D(I+1,J)
      D(I,J)=(D(I,J)+XN)/3.
22    DT(J)=DT(J)+D(I,J)
      D(ND,J)=(XN+XO)/2.
23    DT(J)=DT(J)+D(ND,J)
C
      DO 28 J=1,NDIM
      RC=0.
      DO 24 I=1,ND
      R(I)=0.
      IF(D(I,J).LE.0.) GO TO 24
      XOLN=DLOG(DT(J)) - DLOG(D(I,J))
      IF(XOLN.GT.70.)   GO TO 240
      XO=DEXP(XOLN)
      R(I)=((XO-ONE)/XO/DLOG(XO))**ALPH
      GO TO 250
240   R(I)=(1.D0/XOLN)**ALPH
250   CONTINUE
24    RC=RC+R(I)
      RC=RC/XND
      K=0
      XN=0.
      DR=XN
      I=K
25    K=K+1
      DR=DR+R(K)
      XO=XN
      XN=XI(K,J)
26    IF(RC.GT.DR) GO TO 25
      I=I+1
      DR=DR-RC
      XIN(I)=XN-(XN-XO)*DR/R(K)
      IF(I.LT.NDM) GO TO 26
      DO 27 I=1,NDM
27    XI(I,J)=XIN(I)
28    XI(ND,J)=ONE
C
      IF(IT.LT.ITMX.AND.ACC*DABS(AVGI).LT.SD) GO TO 9
      RETURN
      END
C
C
      SUBROUTINE RANDA(N,RAND)
C
C   SUBROUTINE GENERATES UNIFORMLY DISTRIBUTED RANDOM NO'S X(I),I=1,N
      DIMENSION RAND(N)
      DO 1 I=1,N
1     RAND(I)=RAN2()
      RETURN
      END
C
C
      FUNCTION RAN2()
C
C MACHINE-INDEPENDENT RANDOM NUMBER GENERATOR, GENERAL PURPOSE VERSION
C                     OK AS LONG AS >= 32 BITS
C                      INITIAL IDUM MUST BE < 0
      DIMENSION RDM(31)
      COMMON/RANDM0/IDUM
      DATA IA1,IC1,M1 /1279,351762,1664557/
      DATA IA2,IC2,M2 /2011,221592,1048583/
      DATA IA3,IC3,M3 /15091,6171,29201/
      SAVE 

      IF (IDUM.GE.0) GO TO 2
C INITIALIZATION
      IX1=MOD(-IDUM,M1)
      IX1=MOD(IA1*IX1+IC1,M1)
      IX2=MOD(IX1,M2)
      IX1=MOD(IA1*IX1+IC1,M1)
      IX3=MOD(IX1,M3)
      RM1=1./FLOAT(M1)
      RM2=1./FLOAT(M2)
      DO 1 J=1,31
      IX1=MOD(IA1*IX1+IC1,M1)
      IX2=MOD(IA2*IX2+IC2,M2)
1     RDM(J)=(FLOAT(IX1)+FLOAT(IX2)*RM2)*RM1
C GENERATE NEXT NUMBER IN SEQUENCE
2     IX1=MOD(IA1*IX1+IC1,M1)
      IX2=MOD(IA2*IX2+IC2,M2)
      IX3=MOD(IA3*IX3+IC3,M3)
      J=1+(31*IX3)/M3
      RAN2=RDM(J)
      RDM(J)=(FLOAT(IX1)+FLOAT(IX2)*RM2)*RM1
C OMIT FOLLOWING STATEMENT IF FUNCTION ARGUMENTS PASSED BY VALUE:
      IDUM=IX1
      RETURN
      END

******************************************************

      SUBROUTINE VEGINI
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/BVEG1/NCALL,ITMX,NPRN,NDEV,XL(10),XU(10),ACC
      COMMON/BVEG2/IT,NDO,SI,SWGT,SCHI,XI(50,10)
      COMMON/BVEG3/ALPH,NDMX,MDS
      COMMON/RANDM0/IDUM

      IDUM=-12345
      NCALL=10000
      ITMX=1
      NPRN=-1
      ACC=-1.
      DO 1 I=1,10
      XL(I)=0
1     XU(I)=1.0
      ALPH=1.5
      NDMX=50
      NDO=NDMX
      MDS=1
      NDEV=6
      NDO=1
      DO 2 I=1,50
      DO 2 J=1,10
2     XI(I,J)=1.0
      IT=0.
      SI=0.
      SWGT=0
      SCHI=0.
      END

      SUBROUTINE VEGNNN(NCALL0,MDS0)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/BVEG1/NCALL,ITMX,NPRN,NDEV,XL(10),XU(10),ACC
      COMMON/BVEG3/ALPH,NDMX,MDS

      NCALL=NCALL0
      MDS=MDS0
      RETURN
      END
      
