#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "f_c.h"
#include "vegas.h"

#define ind(i,j) (i)+50*(j)

#define XI(i,j) vegPtr->xi[(i)+(j)*50]
#define DD(i,j) d[(i)+(j)*50]
 vegasGrid *  vegini_(int ndim0,int ndmx)
{
    vegasGrid * vegPtr; 
    int i, j;
    double step;
    
    if(ndim0>10) return NULL;
    vegPtr=(vegasGrid * )malloc(sizeof(vegasGrid));    
    if(vegPtr)
    {  if (ndmx>50)ndmx=50;
       vegPtr->ndmx=ndmx;
       vegPtr->ndim = ndim0;
       step=1/(double)ndmx;
       for (j = 0; j < vegPtr->ndim; ++j) 
       for (i=1;i<= vegPtr->ndmx;++i) XI(i-1,j)=i*step;
    }   	
    return vegPtr;
} /* vegini_ */


/* 
    			*  VEGAS  *
      SUBROUTINE PERFORMS NDIM-DIMENSIONAL MONTE CARLO INTEG'N 
      - BY G.P. LEPAGE    SEPT 1976/(REV)AUG 1979 
      - ALGORITHM DESCRIBED IN J COMP PHYS 27,192(1978) 
*/

int vegas_(vegasGrid * vegPtr, long ncall0, double alph, 
double (*ran2)(void), double (*fxn)( double *,double,long), double *ti, double *tsi)
{
    double d[500]	/* was [50][10] */, f;
    int i, j, ia[10];
    double r[50], x[10], f2, fb;

    long kg[10], nd,
    ng[10],                /*  - number of hipercubes */
      k;
      
    double rc, dr, dt[10], xn, xo, f2b;
    long ndm;
    double  dxg[10];
    long npg;
    double xnd, xin[50], wgt;
    double xjac, xoln;
    double calls;

/*   - NO INITIALIZATION   */

    nd = vegPtr->ndmx; 
        
/*    calls=ncall0/3;
*/
      calls=ncall0/2;
    k=1;
    for(i=0;i<vegPtr->ndim;i++)
    {
       ng[i]  = pow(calls ,((double)1)/ (vegPtr->ndim -i));
       calls /= ng[i];
       k     *=  ng[i];   
    }
    npg=ncall0/k;
    
    if (npg < 2) npg = 2;   
    calls =  npg * k;

    xnd = (double) nd;
    for(i=0;i<vegPtr->ndim;i++)  dxg[i] = xnd/ng[i];

    ndm = nd - 1;
    xjac = 1/calls;
       
/*    - MAIN INTEGRATION LOOP */
    *ti  = 0;
    *tsi = 0;
    for (j = 0; j < vegPtr->ndim; ++j) 
    {
       kg[j] = 1;
       for (i = 0; i < nd; ++i)  DD(i,j) = *ti;	
    }

    do
    {
       fb  = 0;
       f2b = 0;
       k   = 0;
       do 
       {
          ++k; 
          wgt = 1;
          for (j = 0; j < vegPtr->ndim; ++j) 
          {
             xn = (kg[j ] - (*ran2)()) * dxg[j];
	     ia[j ] = (int) xn;
	     if (ia[j] <= 0)
	     {
                 xo = XI(ia[j],j);
                 rc = (xn - ia[j]) * xo;
             } else
             { 
                xo =   XI( ia[j ],j)  - XI(ia[j ] - 1,j);
                rc = XI(ia[j]-1,j) + (xn-ia[j])*xo;
             }
             x[j] = rc;
	     wgt = wgt * xo * xnd;
          }
          f = wgt*xjac*(*fxn)(x , wgt,npg-k);
    
          f2 = f * f;
          fb += f;
          f2b += f2;
          for (j = 0;j<vegPtr->ndim;++j) DD(ia[j],j) += f2;
       } while  (k < npg) ;
    
       f2b = sqrt(f2b * npg);
       f2b = (f2b - fb) * (f2b + fb);
       *ti += fb;
       *tsi += f2b;   
    
       k = vegPtr->ndim;
       do 
       {  k--;
          kg[k] = kg[k] % ng[k] + 1;
       } while (k > 0 && kg[k] == 1  );
    } while(kg[k] != 1);

/*   COMPUTE FINAL RESULT */
    *tsi = sqrt(*tsi/(npg-1));
     
    /*   REFINE GRID */
    for (j = 0; j < vegPtr->ndim ; ++j)
    {
        xo = DD(0,j);
        xn = DD(1,j);
        DD(0,j) = (xo + xn) / 2;
        dt[j] = DD(0,j);
        for (i = 1; i < ndm; ++i)
        {
            DD(i,j) = xo + xn;
            xo = xn;
            xn = DD(i+1, j);
            DD(i,j) = (DD(i,j) + xn) / 3;
            dt[j] += DD(i,j);
        }
        DD(nd-1,j) = (xn + xo) / 2;
        dt[j] += DD(nd-1,j);
    }

    for (j = 0; j < vegPtr->ndim; ++j) 
    {
	rc = 0;
	for (i = 0; i < nd; ++i) 
	{
	   r[i] = 0;
	   if (DD(i,j) > 0)
	   {	    
	      xoln = log(dt[j]/DD(i,j));
	      if (xoln <= 70.f)  r[i] = pow( (1 - exp(-xoln))/xoln, alph);
	       else              r[i] = pow(  1/xoln,               alph);
	   }		        
	   rc += r[i];
	}

	rc /= xnd;

	k  = 0;
	xn = 0;
	dr = 0;
	i  = 0;
	do
	{
           do
           {  dr += r[k];
	      xo = xn;
	      xn = XI(k,j);
	      k++;
	   } while (rc > dr);
	   do 	
	   {  dr -= rc;
	      xin[i] = xn-(xn-xo)*dr/r[k-1];
              i++;
           } while (rc<=dr);   
	} while (i < ndm);
	for (i=0;i<ndm;++i)  XI(i,j) = xin[i];
	XI(nd-1, j) = 1;
    }
    return 0;
} /* vegas_ */
