/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "out_ext.h"
#include "f_c.h"
#include"mrsg.h"
#include"sf_ctq.h"
#include"sf_epa.h"
#include"sf_isr.h"
#include"sf_lsr.h"
#include"sf_mrs.h"
#include"sf_prv.h"
#include"strfun.h"

#include "f_c.h"
#include "subproc.h"
#include "tptcmac.h"
#include "crt_util.h"
#include "syst.h"

#define MAXFUN 6
#define FUNLEN 40  

int sf_num[2]={0,0}; /* switched off */

double strfunScale;


static struct 
{  int (*myParticle)(char*);
   void(*fullName)(int,char *); 
   int (*readName)(int,char*);
   void(*menu)(int);
   double(*init)(int);
   double (*mass)(int);
   double(*val)(int,double);
}  strFun [MAXFUN]={{p_epa__,n_epa__,r_epa__,m_epa__,i_epa__, mass_epa,c_epa__},
                    {p_lsr__,n_lsr__,r_lsr__,m_lsr__,i_lsr__, mass_lsr,c_lsr__},              
                    {p_mrs__,n_mrs__,r_mrs__,m_mrs__,i_mrs__, mass_mrs,c_mrs__},
                    {p_ctq__,n_ctq__,r_ctq__,m_ctq__,i_ctq__, mass_ctq,c_ctq__},
                    {p_isr__,n_isr__,r_isr__,m_isr__,i_isr__, mass_isr,c_isr__},
                    {p_prv  ,n_prv  ,r_prv  ,m_prv  ,be_prv , mass_prv,c_prv  }
                   };

int initStrFun(int i,double * be)
{
  int l=sf_num[i-1];
  char p_name[100];
  *be=0.;
  if(l)
  { l--;
    pinf_( proces_1.nsub,i,p_name,NULL);
    if(! strFun[l].myParticle(p_name) )
    {
      sf_num[i-1]=0;
      messanykey(10,15, "Stucture function is switched OFF$");
      return -1;
    } else
    { 
      *be=strFun[l].init(i);
      return 0;
    }
  }else  return 1;
}


void strFunName(int i, char * mess)
{
  if(sf_num[i-1]) strFun[sf_num[i-1]-1].fullName(i,mess); 
  else strcpy(mess,"OFF");
}

void sf_menu__(int i)
{
    int  k;
    char name[STRSIZ];
    int  nfun[MAXFUN];
    char p_name__[10];
    char strmen[2+MAXFUN*(FUNLEN+1)];

    void * pscr =NULL;
    int mode,l;

    strmen[0]=FUNLEN+1;

    pinf_( proces_1.nsub,i,p_name__,NULL );
    
    sprintf(strmen+1," %-*.*s",FUNLEN,FUNLEN,"OFF");

    k = 0;          
    for(l=0;l<MAXFUN;l++)
    {    
       if ( strFun[l].myParticle(p_name__)  ) 
       {  
          nfun[k++] = l;
          strFun[l].fullName(i, name); 
	  sprintf(strmen+1+(FUNLEN+1)*k," %-*.*s",FUNLEN,FUNLEN,name);
       }
    }
    if(!k) 
    { messanykey(15,15,"Structure functions for this particle$"
                       "are not known$");
      return;
    }                  

    menu1(77-FUNLEN,7,"",strmen, "n_strfun", &pscr, &mode );
    if (mode == 0) return;
    
    if (mode == 1) sf_num[i-1]=0;
    else
    { 
       strFun[nfun[mode - 2]].menu(i);
       sf_num[i-1]=nfun[mode -2]+1;
    }
    put_text(&pscr);
} /* sf_menu__ */

double totMass(int i) { return strFun[sf_num[i-1]-1].mass(i);}

double strfun_(int i, double x)
{ return strFun[sf_num[i-1]-1].val(i,x);}

int rd_sf__(FILE *mode)
{ char sf_txt[2][STRSIZ];
  char p_name[100];
  int l, i;

  for(i=0;i<2;i++) sf_num[i]=0;
 
  if(2 != fscanf(mode,"%*c%[^\n]%*c%[^\n]%*c",sf_txt[0],sf_txt[1])) return 1;

  for(i=0;i<2;i++)
  { pinf_( proces_1.nsub,i+1,p_name,NULL );
    for(l=0;l<MAXFUN;l++)
    if(strFun[l].myParticle(p_name)  && strFun[l].readName(i+1,sf_txt[i]))
    { sf_num[i] = l+1; 
      break; 
    }
  }                                                                       
}


int wrt_sf__(FILE *mode)
{  
   char sf_txt[2][STRSIZ];
   int i;
   for(i=0;i<2;i++) 
   if(sf_num[i]) strFun[sf_num[i]-1].fullName(i+1,sf_txt[i]);
   else strcpy(sf_txt[i],"OFF");
   fprintf(mode,"%s\n%s\n",sf_txt[0],sf_txt[1]); return 0; 
}
